/*-*/
/*****************************************************************
 * Rozszerzona wersja funkcji fgets	umozliwiajaca rejestrowanie  *
 * i odtwarzanie wprowadzanych danych                            *
 *****************************************************************/
/*+*/
#include <stdio.h>
FILE *save_file = NULL;         /* zapisuje dane wejsciowe w tym pliku */
FILE *playback_file = NULL;     /* wczytuje dane wejsciowe z tego pliku */
/********************************************************
 * extended_fgets - wczytuje wiersz z pliku wejsciowego *
 *              i w razie potrzeby zapisuje go w pliku  *
 *              rejestru.                               *
 * Parametry                                            *
 *      line -- wiersz do wczytania                     *
 *      size -- sizeof(line) -- maksymalna liczba       *
 *                      wczytywanych znakow             * 
 *      file -- plik, z ktorego sa wczytywane dane      *
 *              (standardowo stdin)                     *
 *                                                      *
 * Wartosc zwracana                                     *
 *      NULL - blad lub osiagnieto koniec pliku,         *
 *      w przeciwnym razie wczytany wiersz              *
 *      (jak w przypadku funkcji fgets)                 *
 ********************************************************/
char *extended_fgets(char *line, int size, FILE *file)
{
    extern FILE *save_file;     /* plik przechowujacy lancuchy */
    extern FILE *playback_file; /* plik na dodatkowe dane wejsciowe */

    char *result;               /* wynik funkcji fgets */

    if (playback_file != NULL) {
        result = fgets(line, size, playback_file);
        /* wyswietla dane wejsciowe na standardowym wyjsciu,*/
        /* aby byly widoczne dla uzytkownika */
        fputs(line, stdout);
    } else
	/* standardowo laduje wiersz */
        result = fgets(line, size, file);

    /* Czy ktos prosil o zapisanie pliku? */
    if (save_file != NULL) 
        fputs(line, save_file); /* zapisuje wiersz w pliku */

    return (result);
}
