/*-*/
/********************************************************
 * Jest to przyklad programu bazodanowego, do ktorego	  *
 * nie dodano jeszcze kodu obslugujacego rejestrowanie  *
 * i wykrywanie bledow.		                          *
 ********************************************************/
/*+*/
/********************************************************
 * Database --  Bardzo prosty program bazodanowy        *
 *              wyszukujacy imie na wbudowanej liscie.  *
 *                                                      *
 * Zastosowanie:                                        *
 *      database                                        *
 *             Program poprosi o podanie imienia.       *
 *             Po jego wprowadzeniu program poinformuje *
 *             czy znajduje sie ono na liscie.          *
 *                                                      *
 * Nie podanie imienia powoduje zamkniecie programu.    *
 ********************************************************/
#define STRING_LENGTH 80        /* dlugosc lancucha */
#include <stdio.h>
#include <string.h>

int main()
{
    char name[STRING_LENGTH];   /* szukane imie */
    int lookup(char const *const name); /* szukane imie */

    while (1) {
        printf("Podaj imie: ");
        fgets(name, sizeof(name), stdin);

        /* sprawdzenie czy podano imie */
        /* (nalezy pamietac o 1 znaku dla znaku nowej linii) */
        if (strlen(name) <= 1)
            break;

        /* usuniecie znaku nowej linii */
        name[strlen(name)-1] = '\0';

        if (lookup(name)) 
            printf("%s jest na liscie\n", name);
        else
            printf("%s nie jest na liscie\n", name);
    }
    return (0);
}
/********************************************************
 * lookup -- szuka imienia na liscie                    *
 *                                                      *
 * Parametry                                            *
 *      name -- szukane imie                            *
 *                                                      *
 * Wartosc zwracana                                     *
 *      1 - imie jest na liscie                         *
 *      0 - imienia nie ma na liscie                    *
 ********************************************************/
int lookup(char const *const name)
{
    /* Lista osob w bazie danych */
    /* Uwaga: Stala NULL oznacza koniec listy */
    static char *list[] = {
        "John",
        "Jim",
        "Jane",
        "Clyde",
        NULL
    };

    int index;          /* indeks listy */

    for (index = 0; list[index] != NULL; ++index) {
        if (strcmp(list[index], name) == 0)
            return (1);
    }
    return (0);
}
