/****************************************
 * copy - kopiuje jeden plik do innego. *
 *                                      *
 * Zastosowanie                         *
 *      copy <z> <do>                   *
 *                                      *
 * <z> -- plik zrodlowy                 *
 * <do>   -- plik docelowy              *
 ****************************************/
#include <stdio.h>
#ifndef __MSDOS__       /* jesli nie jest to system MS-DOS, */
#define __UNIX__        /* zatem jest to system UNIX */
#endif /* __MSDOS__ */

#include <stdlib.h>     

#ifdef __UNIX__
#include <sys/types.h>  /* definicja pliku systemu plikow systemu UNIX */
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#endif /* __UNIX__ */

#ifdef __MSDOS__
#include <fcntl.h>     /* definicja pliku systemu plikow systemu DOS */
#include <sys\stat.h>
#include <io.h>
#endif __MSDOS__

#ifndef O_BINARY
#define O_BINARY 0     /* definicja znacznika, jesli jeszcze nie istnieje */
#endif /* O_BINARY */

#define BUFFER_SIZE (16 * 1024) /* uzycie bufora o rozmiarze 16Kb */

int main(int argc, char *argv[])
{
    char  buffer[BUFFER_SIZE];  /* bufor danych */
    int   in_file;              /* deskryptor pliku zrodlowego */
    int   out_file;             /* deskryptor pliku docelowego */
    int   read_size;            /* ilosc bajtow odczytanych w ostatniej operacji */

    if (argc != 3) {
        fprintf(stderr, "Blad: Nieprawidlowa ilosc argumentow\n");
        fprintf(stderr, "Format funkcji: copy <z> <do>\n");
        exit(8);
    }
    in_file = open(argv[1], O_RDONLY|O_BINARY);
    if (in_file < 0) {
        fprintf("Blad: Nie mozna bylo otworzyc pliku %s\n", argv[1]);
        exit(8);
    }
    out_file = open(argv[2], O_WRONLY|O_TRUNC|O_CREAT|O_BINARY, 0666);
    if (out_file < 0) {
        fprintf("Blad: Nie mozna bylo otworzyc pliku %s\n", argv[2]);
        exit(8);
    }
    while (1) {
        read_size = read(in_file, buffer, sizeof(buffer));

        if (read_size == 0)
            break;              /* koniec pliku */

        if (read_size < 0) {
            fprintf(stderr, "Blad: Blad odczytu\n");
            exit(8);
        }
        write(out_file, buffer, (unsigned int) read_size);
    }
    close(in_file);
    close(out_file);
    return (0);
}
