/*-*/
/**************************************************************
 * extended_fgets -- rozszerzona wersja funkcji fgets	        *
 *		umozliwiajaca rejestrowanie wprowadzanych danych. *
 **************************************************************/
/*+*/
#include <stdio.h>
/*
 * Glowny program otwiera ten plik, jesli opcja -S zostala 
 * wprowadzona w linii polecenia.
 */
FILE *save_file = NULL; 
/********************************************************
 * extended_fgets - wczytuje wiersz z pliku wejsciowego *
 *              i w razie potrzeby zapisuje go w pliku  *
 *              rejestru.                               *
 * Parametry                                            *
 *      line -- wiersz do wczytania                     *
 *      size -- sizeof(line) - maksymalna liczba        *
 *                      wczytywanych znakow             *
 *      file - plik, z ktorego sa wczytywane dane       *
 *              (standardowo stdin)                     *
 *                                                      *
 * Wartosc zwracana                                     *
 *      NULL - blad lub osiagnieto koniec pliku,        *
 *      w przeciwnym razie wczytany wiersz              *
 *      (jak w przypadku funkcji fgets)                 *
 ********************************************************/
char *extended_fgets(char *line, int size, FILE *file)
{
    char *result;               /* wynik funkcji fgets */

    result = fgets(line, size, file);

    /* Czy ktos prosil o zapisanie pliku? */
    if (save_file != NULL) 
        fputs(line, save_file);	/* zapisanie wiersza w pliku rejestru */

    return (result);
}
