/********************************************************************
 * words -- przeszukuje plik i wyswietla w kolejnosci alfabetycznej *
 *              liste zawartych w nim slow.                         *
 *                                                                  *
 * Zastosowanie                                                     *
 *      words <plik>                                                *
 ********************************************************************/
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>    

struct node {
    struct node    *left;       /* lewe drzewo */
    struct node    *right;      /* prawe drzewo */
    char           *word;       /* slowo znajdujace sie w drzewie */
};

/* wierzcholek drzewa */
static struct node *root = NULL;

/***************************************************************
 * memory_error - wyswietla komunikat bledu i konczy dzialanie *
 ***************************************************************/
void memory_error(void)
{
    fprintf(stderr, "Blad:Brak pamieci\n");
    exit(8);
}

/***************************************************************
 * save_string -- zapisuje lancuch na stercie                  *
 *                                                             *
 * Parametry                                                   * 
 *      string -- zapisywany lancuch                           *
 *                                                             *
 * Wartosc zwracana                                            *
 *      wskaznik do obszaru pamieci przetworzonego przez       *
 *      funkcje malloc zawierajacego umieszczony w nim lancuch.*
 ***************************************************************/
char *save_string(char *string)
{
    char *new_string;   /* miejsce umieszczenia lancucha */

    new_string = malloc((unsigned) (strlen(string) + 1));

    if (new_string == NULL)
        memory_error();

    strcpy(new_string, string);
    return (new_string);
}
/********************************************************
 * enter -- umieszcza slowo w drzewie                   *
 *                                                      *
 * Parametry                                            *
 *      node -- aktualnie szukany wezel                 *
 *      word -- wstawiane slowo                         *
 ********************************************************/
void enter(struct node **node, char *word)
{
    int  result;        /* wynik dzialania funkcji strcmp */

    char *save_string(char *);  /* zapisanie lancucha na stercie */

    /* 
     * Jesli aktualny wezel jest pusty, oznacza to, ze zostal
     * osiagniety dol drzewa i nalezy utworzyc nowy wezel.
     */
    if ((*node) == NULL) {

	/* Przydzielenie pamieci dla nowego wezla */
        (*node) = malloc(sizeof(struct node));
        if ((*node) == NULL)
            memory_error();

	/* Inicjalizacja nowego wezla */
        (*node)->left = NULL;
        (*node)->right = NULL;
        (*node)->word = save_string(word);
	return;
    }
    /* Kontrola miejsca, w ktorym zostanie wstawione slowo */
    result = strcmp((*node)->word, word);

    /* Aktualny wezel zawiera juz slowo, a zatem nie jest wymagana */
    /* operacja wstawiania */
    if (result == 0)
        return;

    /* Slowo musi byc wstawione w lewym lub prawym poddrzewie */
    if (result < 0)
        enter(&(*node)->right, word);
    else
        enter(&(*node)->left, word);
}
/********************************************************
 * scan -- szuka slow w pliku                           *
 *                                                      *
 * Parametry                                            *
 *      name -- nazwa przeszukiwanego pliku             *
 ********************************************************/
void scan(char *name)
{
    char word[100];     /* przetwarzane slowo */
    int  index;         /* indeks slowa */
    int  ch;            /* aktualny znak */
    FILE *in_file;      /* plik wejsciowy */

    in_file = fopen(name, "r");
    if (in_file == NULL) {
        fprintf(stderr, "Blad:Nie mozna otworzyc pliku %s\n", name);
        exit(8);
    }
    while (1) {
        /* szuka za znakiem spacji */
        while (1) {
            ch = fgetc(in_file);

            if (isalpha(ch) || (ch == EOF))
                break;
        }

        if (ch == EOF)
            break;

        word[0] = ch;
        for (index = 1; index < sizeof(word); ++index) {
            ch = fgetc(in_file);
            if (!isalpha(ch))
                break;
            word[index] = ch;
        }
        /* wstawia na koncu znak konca linii */
        word[index] = '\0';

        enter(&root, word);
    }
    fclose(in_file);
}
/********************************************************
 * print_tree -- wyswietla slowa zawarte w drzewie      *
 *                                                      *
 * Parametry                                            *
 *      top - korzen wyswietlanego drzewa               *
 ********************************************************/
void print_tree(struct node *top)
{
    if (top == NULL)
        return;                 /* niskie drzewo */

    print_tree(top->left);
    printf("%s\n", top->word);
    print_tree(top->right);
}

int main(int argc, char *argv[])
{
    if (argc != 2) {
        fprintf(stderr, "Blad:Nieprawidlowa ilosc parametrow\n");
        fprintf(stderr, "      podanych w linii polecen\n");
        fprintf(stderr, "Skladnia funkcji:\n");
        fprintf(stderr, "    words 'plik'\n");
        exit(8);
    }
    scan(argv[1]);
    print_tree(root);
    return (0);
}
