/**************************************************************
 * gra guess - prosta zgadywanka                              *
 *                                                            *
 * Zastosowanie:                                              *
 *      guess                                                 *
 *                                                            *
 *      Nalezy wybrac losowo liczbe z zakresu od 0 do 100.    *
 *      Gracz ma do dyspozycji zakres, z ktorego musi wybrac  *
 *      liczbe. Jesli gracz wybierze prawidlowa liczbe, wtedy *
 *      wygrywa. W innym przypadku zakres wartosci jest       *
 *      zmieniany zgodnie z liczba wybrana przez gracza i     *
 *      nastepnie gra jest kontynuowana.                      *
 *                                                            *
 *                                                            *
 * Ograniczenia:                                              *
 *      Liczba losowa jest generowana przez instrukcje        *
 *      rand() % 100. Poniewaz funkcja rand() zwraca          *
 *      liczbe z zakresu 0 <= rand() <= maxint w efekcie      *
 *      czesciej moga wystepowac liczby mniejsze.             *
 *                                                            *
 **************************************************************/
#include <stdio.h>
#include <stdlib.h>   
int   number_to_guess;  /* odgadywana liczba losowa */
int   low_limit;        /* aktualna dolna wartosc zakresu dla gracza */
int   high_limit;       /* aktualna gorna wartosc zakresu dla gracza */
int   guess_count;      /* ilosc trafien gracza */
int   player_number;    /* liczba podana przez gracza */
char  line[80];         /* zmienna przechowujaca dane wejsciowe */
int main()
{
    while (1) {
        /*
         * nie do konca prawdziwa liczba losowa, patrz - ograniczenia
         */
        number_to_guess = rand() % 100 + 1;

        /* inicjalizacja zmiennych petli */
        low_limit = 0;
        high_limit = 100;
        guess_count = 0;

        while (1) {
            /* podanie graczowi wartosci zakresu 
               i pobranie od niego liczby  */
            printf("Zakres %d - %d\n", low_limit, high_limit);
            printf("Wartosc[%d]? ", guess_count);

            ++guess_count;

            fgets(line, sizeof(line), stdin);
            sscanf(line, "%d", &player_number);

            /* czy gracz trafil? */
            if (player_number == number_to_guess)
                break;

            /* dopasowanie zakresu do nastepnej proby */
            if (player_number < number_to_guess)
                low_limit = player_number;
            else
                high_limit = player_number;

        }
        printf("Trafione\n");
    }
}
