/********************************************************
 * input_file -- dane wczytywane z pliku wejsciowego    *
 *							              *
 * Aktualne dwa znaki sa zapisane w         		  *
 *	cur_char oraz next_char		                    *
 * Wiersze sa buforowane, dlatego tez po ich zlozeniu   *
 * moga one byc wyswietlane na ekranie.		        *
 *							              *
 * Funkcje:						              *
 *	in_open -- otwiera plik wejsciowy.		        *
 *	in_close -- zamyka plik wejsciowy.		        *
 *	read_char   -- wczytuje nastepny znak.	        *
 *	in_char_char -- zwraca aktualny znak.             *
 *	in_next_char -- zwraca nastepny znak.             *
 *	in_flush -- wyswietla wiersz na ekranie.          *
 ********************************************************/

/********************************************************
 * in_open -- otwiera plik wejsciowy			  *
 *							              *
 * Parametry						        *
 *	name -- nazwa pliku wejsciowego	              *
 *							              *
 * Wartosc zwracana					        *
 *	0 -- udana operacja otwarcia.			        *
 *	nonzero -- nieudana operacja otwarcia.	        *
 ********************************************************/
extern int in_open(const char name[]);

/********************************************************
 * in_close -- zamyka plik wejsciowy.			  *
 ********************************************************/
extern void in_close(void);

/********************************************************
 * in_read_char -- wczytuje nastepny znak 	        *
 *	z pliku wejsciowego				        *
 ********************************************************/
extern void in_read_char(void);

/**************************************************************
 * in_cur_char -- wczytuje aktualny znak znajdujcy sie       *
 *                na wejsciu	                                *
 *							                    *
 * Wartosc zwracana						        *
 *	aktualny znak.				                    *
 *************************************************************/
extern int in_cur_char(void);

/********************************************************
 * in_next_char -- podnosi wierzcholek o jeden znak     *
 *							              *
 * Wartosc zwracana					        *
 *	nastepny znak.					        *  
 ********************************************************/
extern int in_next_char(void);

/********************************************************
 * in_flush -- przesyla buforowany wiersz na ekran.	  *
 *							              *
 ********************************************************/
extern void in_flush(void);
