/********************************************************
 * modul infile.					              *
 *	Otwiera, wczytuje i wyswietla 	              *
 *	dane pliku wejsciowego.			              *
 *							              *
 * Funkcje:						              *
 *	in_open -- otwiera plik wejsciowy.		        *
 *	in_close -- zamyka plik wejsciowy.		        *
 *	read_char   -- wczytuje nastepny znak.	        *
 *	in_char_char -- zwraca aktualny znak.             *
 *	in_next_char -- zwraca nastepny znak.             *
 *	in_flush -- wyswietla wiersz na ekranie.          *
 ********************************************************/
#include <stdio.h>
#include <errno.h>

#include "in_file.h"

#define LINE_MAX 500	/* maksymalna dlugosc wiersza */

struct input_file {
    FILE *file;		/* wczytywany plik */
    char line[LINE_MAX];/* aktualny wiersz */
    char *char_ptr;	/* aktualny znak w wierszu */

    int cur_char;	/* aktualny znak (moze to byc znak konca pliku) */
    int next_char;	/* nastepny znak (moze to byc znak konca pliku) */
};

/* wczytywany plik wejsciowy */
static struct input_file in_file = {
    NULL,		/* plik */
    "",			/* wiersz */
    NULL,		/* funkcja char_ptr */
    '\0',		/* funkcja cur_char */
    '\0'		/* funkcja next_char */
};


/********************************************************
 * in_open -- otwiera plik wejsciowy			  *
 *							              *
 * Parametry						        *
 *	name -- nazwa pliku wejsciowego	              *
 *							              *
 * Wartosc zwracana					        *
 *	0 -- udana operacja otwarcia.			        *
 *	nonzero -- nieudana operacja otwarcia.            * 
 ********************************************************/
int in_open(const char name[])
{
   in_file.file = fopen(name, "r");
   if (in_file.file == NULL)
       return (errno);

    /*
     * Inicjalizacja pliku wejsciowego i wczytanie pierwszych dwoch 
     * znakow.
     */
    in_file.cur_char = fgetc(in_file.file);
    in_file.next_char = fgetc(in_file.file);
    in_file.char_ptr = in_file.line;
    return (0);
}

/********************************************************
 * in_close -- zamyka plik wejsciowy.			  *
 ********************************************************/
void in_close(void) 
{
    if (in_file.file != NULL) {
	fclose(in_file.file);
	in_file.file = NULL;
    }
}

/********************************************************
 * in_cur_char -- wczytuje aktualny znak znajdujcy sie *
 *                na wejsciu	                          *
 *							              *
 * Wartosc zwracana					        *
 *	aktualny znak.				              *
 ********************************************************/
int in_cur_char(void) 
{
   return (in_file.cur_char);
}

/********************************************************
 * in_next_char -- podnosi wierzcholek o jeden znak     *
 *							              *
 * Wartosc zwracana					        *
 *	nastepny znak.					        *
 ********************************************************/
int in_next_char(void)
{
   return (in_file.next_char);
}

/********************************************************
 * in_flush -- przesyla buforowany wiersz na ekran.     *
 ********************************************************/
void in_flush(void)
{
    *in_file.char_ptr = '\0';		/* koniec wiersza */
    fputs(in_file.line, stdout);	/* wysyla wiersz */
    in_file.char_ptr = in_file.line;	/* zeruje wiersz */
}

/********************************************************
 * in_read_char -- wczytuje nastepny znak 	        *
 *	z pliku wejsciowego				        *
 ********************************************************/
void in_read_char(void)
{
    *in_file.char_ptr = in_file.cur_char;
    ++in_file.char_ptr;

    in_file.cur_char = in_file.next_char;
    in_file.next_char = fgetc(in_file.file);
};
