/**************************************************************
 * sine -- wyznacza wartosc funkcji sinus przy uzyciu         *
 *        bardzo prostych operacji na liczbach rzeczywistych  *                                              
       *                                                      *
 * Zastosowanie:                                              *
 *      sine <wartosc>                                        *
 *                                                            *
 *      <wartosc> jest katem wyrazonym w radianach            *
 *                                                            *
 * Stosowany format: f.fffe+X                                 *
 *                                                            *
 * f.fff jest 4-cyfrowym ulamkiem                             *
 *      + jest znakiem(+ lub -)                               *
 *      X jest 1-cyfrowym wykladnikiem                        *
 *                                                            *
 * sine(x) = x  - x**3 + x**5 - x**7                          *
 *               -----   ----   ---- . . . .                  *
 *                 3!     5!     7!                           *
 *                                                            *
 * Ostrzezenie: Program ma za zadanie zaprezentowac           *
 *      niektore z problemow zwiazanych z liczbami            *
 *      zmiennoprzecinkowymi. Nie moze byc stosowany          *
 *      do generowania dokladnych wartosci funkcji sinus.     *
 *                                                            *
 * Uwaga: Nawet pomimo, ze dla wykladnika zostala okreslona   *
 *       tylko jedna cyfra, sa w przypadku pewnych obliczen   *
 *       stosowa	ne dwie. Jest to konieczne, poniewaz        *
 *       funkcja printf nie posiada formatu dla wykadnika    *
 *        jednocyfrowego.                                     *
 **************************************************************/
#include <stdlib.h>	
#include <math.h>
#include <stdio.h>

/*********************************************************
 * float_2_ascii -- zamienia lancuch zmiennoprzecinkowy  *
 *      na tekstowy.                                     *
 *                                                       *
 * Parametry                                             *
 *      number -- zamieniana liczba na tekst             *
 *                                                       *
 * Wartosc zwracana                                      *
 *      Wskaznik do lancucha zawierajacego liczbe        *
 *                                                       *
 * Ostrzezenie: Stosuje statyczna postac zapisu,         *
 *              dlatego tez pozniejsze wywolania         *
 *              nadpisuja wczesniejsze wpisy.            *
 ********************************************************/
static char *float_2_ascii(float number)
{
    static char result[10]; /* miejsce wstawienia liczby */

    sprintf(result,"%8.3E", number);
    return (result);
}
/********************************************************
 * fix_float -- w celu zasymulowania bardzo prostej     *
 *             struktury liczb zmiennoprzecinkowych     *
 *             zamienia liczby o wysokiej dokladnosci   *
 *             na liczby o mniejszej dokladnosci        *
 *                                                      *
 * Parametry                                            *
 *      number -- przetwarzana liczba                   *
 *                                                      *
 * Wartosc zwracana                                     *
 *      liczba z dokladnoscia do 5 cyfr                 *
 *                                                      *
 * Uwaga: Dzialanie polega na zamianie liczby na tekst, *
 *       a nastepnie wykonaniu operacji odwrotnej.      *
 *       Operacja jest powolna, ale dziala prawidlowo.  *
 ********************************************************/
float fix_float(float number)
{
    float   result;         /* wynik konwersji */
    char    ascii[10];      /* postac tekstowa liczby */

    sprintf(ascii,"%8.4e", number);
    sscanf(ascii, "%e", &result);
    return (result);
}
/********************************************************
 * factorial -- wyznacza czesc ulamkowa liczby.         *
 *                                                      *
 * Parametry                                            *
 *      number -- przetwarzana liczba                   *
 *                                                      *
 * Wartosc zwracana                                     *
 *      liczba ulamkowa lub bez ulamka!                 *
 *                                                      *
 * Uwaga: Pomimo to, ze jest to funkcja wykonujaca      *
 *       operacje na liczbach zmiennoprzecinkowych      *
 *       zastosowanie tego typu liczb nie ma sensu.     *
 ********************************************************/
float factorial(float number)
{
    if (number <= 1.0)
	return (number);
    else
	return (number *factorial(number - 1.0));
}

int main(int argc, char *argv[])
{
    float   total;  /* ilosc wykonanych cykli */
    float   new_total;/* bardziej aktualna wartosc zmiennej total */
    float   term_top;/* gorna czesc szeregu */
    float   term_bottom;/* dolna czesc szeregu */
    float   term;   /* aktualna wartosc szeregu */
    float   exp;    /* wykladnik aktualnej wartosci szeregu */
    float   sign;   /* +1 lub -1 (zmienia sie dla kazdej wartosci szeregu) */
    float   value;  /* wartosc argumentu funkcji sinus */
    int     index;  /* indeks wyznaczonych wartosci szeregu */

    if (argc != 2) {
	fprintf(stderr,"Zastosowanie:\n");
	fprintf(stderr,"  sine <wartosc>\n");
	exit (8);
    }

    value = fix_float(atof(&argv[1][0]));

    total = 0.0;
    exp = 1.0;
    sign = 1.0;

    for (index = 0; /* wykonuje ponizsze instrukcje */ ; ++index) {
	term_top = fix_float(pow(value, exp));
	term_bottom = fix_float(factorial(exp));
	term = fix_float(term_top / term_bottom);
	printf("x**%d     %s\n", (int)exp, 
			float_2_ascii(term_top));
	printf("%d!       %s\n", (int)exp, 
			float_2_ascii(term_bottom));
	printf("x**%d/%d! %s\n", (int)exp, (int)exp,
		float_2_ascii(term));
	printf("\n");
	new_total = fix_float(total + sign * term);
	if (new_total == total)
	    break;
	total = new_total;
	sign = -sign;
	exp = exp + 2.0;
	printf("  Wartosc calkowita   %s\n", float_2_ascii(total));
	printf("\n");
    }
    printf("%d wartosc szeregu wyliczona\n", index+1);
    printf("sin(%s)=\n", float_2_ascii(value));
    printf("  %s\n", float_2_ascii(total));
    printf("Wartosc funkcji wynosi sin(%G)=%G\n",
	    atof(&argv[1][0]), sin(atof(&argv[1][0])));
    return (0);
}
