/*-*/
/***************************************************************
 * Nazwa: File size					               *
 *							                     *
 * Cel: Okreslenie ilosci znakow w pliku.	                     *
 *							                     *
 * Zastosowanie: Uruchom program. Zostanie okreslona ilosc	   *
 *	znakow w pliku "input.txt".			               *
 *							                     *
 * Ograniczenia: Zostal uzyty tylko plik o nazwie "input.txt". *
 *	Program liczy znak konca linii jako jeden znak nawet 	   *
 *	pomimo tego, ze system DOS zapisuje go jako dwa znaki.   *
 *							                     *
 * Uwagi: Lepsza metoda wykonania tego zadania polega	         *
 *	na zastosowaniu wywolania systemowego "stat".		   *
 ***************************************************************/
/*+*/
#include <stdio.h>
const char FILE_NAME[] = "input.txt";
#include <stdlib.h> 

int main()
{
    int             count = 0;  /* ilosc przetworzonych znakow */
    FILE           *in_file;    /* plik wejsciowy */

    /* znak lub znacznik EOF pobrany z pliku wejsciowego */
    int             ch;

    in_file = fopen(FILE_NAME, "r");
    if (in_file == NULL) {
        printf("Nie mozna otworzyc pliku %s\n", FILE_NAME);
        exit(8);
    }

    while (1) {
        ch = fgetc(in_file);
        if (ch == EOF)
            break;
        ++count;
    }
    printf("Ilosc znakow w pliku %s wynosi %d\n",
                  FILE_NAME, count);

    fclose(in_file);
    return (0);
}
