/***********************************************************
 * token -- modul przetwarzajacy znaczniki	           * 
 *							                 *
 * Funkcja:						                 *
 *	next_token -- pobiera nastepny znacznik z wejscia    *
 ***********************************************************/
#include <stdio.h>
#include <stdlib.h>

#include "ch_type.h"
#include "in_file.h"
#include "token.h"

static int in_comment = FALSE;	/* prawda (TRUE), jesli jest to komentarz */

/***************************************************************
 * read_comment -- wczytuje komentarz			         *
 *							                     *
 * Wartosc zwracana					               *
 *	Wczytany znacznik.  Moze nim byc T_COMMENT               *
 *	lub T_NEW_LINE w zaleznosci od wczytanych danych.	   *
 *							                     *
 *	Komentarze zajmujace kilka wierszy sa  	               *
 *	dzielona na wiele znacznikow.				         *
 ***************************************************************/
static enum TOKEN_TYPE read_comment(void)
{
    if (in_cur_char() == '\n') {
	in_read_char();
	return (T_NEWLINE);
    }
    while (1) {
	in_comment = TRUE;
	if (in_cur_char() == EOF) {
	    fprintf(stderr, "Blad: Znak konca pliku wewnatrz komentarza\n");
	    return (T_EOF);
	}
	if (in_cur_char() == '\n')
	    return (T_COMMENT);
	if ((in_cur_char() == '*') && 
	    (in_next_char() == '/')) {
	    in_comment = FALSE;
	    /* przeskok na koniec */
	    in_read_char();
	    in_read_char();
	    return (T_COMMENT);
	}
	in_read_char();
    }
}
/*********************************************************************
 * next_token - wczytuje nastepny znacznik z wejsciowego strumienia  *
 *							                           *
 * Wartosc zwracana						               *
 *	nastepny znacznik					                     *
 *********************************************************************/
enum TOKEN_TYPE next_token(void)
{
    if (in_comment)
	return (read_comment());

    while (is_char_type(in_cur_char(), C_WHITE)) {
	in_read_char();
    }
    if (in_cur_char() == EOF)
	return (T_EOF);

    switch (get_char_type(in_cur_char())) {
	case C_NEWLINE:
	    in_read_char();
	    return (T_NEWLINE);
	case C_ALPHA:
	    while (is_char_type(in_cur_char(), C_ALPHA_NUMERIC))
		in_read_char();
	    return (T_ID);
	case C_DIGIT:
	    in_read_char();
	    if ((in_cur_char() == 'X') || (in_cur_char() == 'x')) {
		in_read_char();
		while (is_char_type(in_cur_char(), C_HEX_DIGIT))
		    in_read_char();
		return (T_NUMBER);
	    }
	    while (is_char_type(in_cur_char(), C_DIGIT))
		in_read_char();
	    return (T_NUMBER);
	case C_SLASH:
	    /* Sprawdzenie, czy nie ma znakow '/', '*' */
	    if (in_next_char() == '*') {
		return (read_comment());
	    }
	    /* rozne przypadki */
	case C_OPERATOR:
	    in_read_char();
	    return (T_OPERATOR);
	case C_L_PAREN:
	    in_read_char();
	    return (T_L_PAREN);
	case C_R_PAREN:
	    in_read_char();
	    return (T_R_PAREN);
	case C_L_CURLY:
	    in_read_char();
	    return (T_L_CURLY);
	case C_R_CURLY:
	    in_read_char();
	    return (T_R_CURLY);
	case C_DOUBLE:
	    while (1) {
		in_read_char();
		/* szuka konca lancucha */
		if (in_cur_char() == '"')
		    break;

		/* Znak ucieczki, a nastepnie pomija nastepny znak */
		if (in_cur_char() == '\\')
		    in_read_char();
	    }
	    in_read_char();
	    return (T_STRING);
	case C_SINGLE:
	    while (1) {
		in_read_char();
		/* szuka konca znaku */
		if (in_cur_char() == '\'')
		    break;

		/* Znak ucieczki, a nastepnie pomija nastepny znak */
		if (in_cur_char() == '\\')
		    in_read_char();
	    }
	    in_read_char();
	    return (T_STRING);
	default:
	    fprintf(stderr, "Blad wewnetrzny: Bardzo dziwny znak\n");
	    abort();
    }
    fprintf(stderr, " Blad wewnetrzny: To nie powinno nigdy wystapic\n");
    abort();
    return (T_EOF);	/* To tez nie powinno nigdy wystapic */
			/* Instrukcja return zapobiega wyswietleniu przez */
			/* kompilator ostrzezenia. */
}
