/*-*/
/**********************************************************
 * Pytanie: Dlaczego ta funkcja raz dziala prawidlowo, a  *
 * innymi razy nie?				                *
 **********************************************************/
/*+*/
#include <stdio.h>
#include <string.h>

struct linked_list {
   struct linked_list *next_ptr;	/* nastepna pozycja na liscie */
   char *data;				/* dane przechowywane na liscie */
};

struct linked_list *first_ptr;
/************************************************************
 * find -- szuka danych przechowywanych przez pozycje listy *
 *                                                          * 
 * Parametry                                                *
 *      name - nazwa szukana na liscie                      *                
 *                                                          *
 * Wartosc zwracana                                         *
 *      1 jesli nazwa zostala znaleziona                    *
 *      0 jesli nazwa nie zostala znaleziona                *
 ************************************************************/
int find(char *name)
{
    /* aktualnie przeszukiwana struktura */
    struct linked_list *current_ptr;

    current_ptr = first_ptr;

    while ((strcmp(current_ptr->data, name) != 0) &&
           (current_ptr != NULL))
        current_ptr = current_ptr->next_ptr;

    /*
     * Jesli wskaznik current_ptr ma wartosc null, wtedy zostanie osiagniety koniec 
     * listy i nazwa nie zostanie znaleziona
     */
    return (current_ptr != NULL);
}
