/********************************************************
 * Database --  Bardzo prosty program bazodanowy        *
 *              wyszukujacy imie na wbudowanej liscie.  *
 *                                                      *
 * Zastosowanie:                                        *
 *      database [-S<plik>] [-P<plik>]                  *
 *                                                      *
 *      -S<plik>        okresla plik rejestru           *
 *                      do operacji wykrywania bledow   *
 *                                                      *
 *      -P<plik>        okresla plik danych wejsciowych *
 *                      do operacji wykrywania bledow   *
 *                      lub dla celow demonstracyjnych  *
 *                                                      *
 *             Program poprosi o podanie imienia.       *
 *             Po jego wprowadzeniu program poinformuje *
 *             czy znajduje sie ono na liscie.          *
 *                                                      *
 * Nie podanie imienia powoduje zamkniecie programu.    *
 ********************************************************/
#include <stdio.h>
#include <stdlib.h>

FILE *save_file = NULL; /* plik rejestru (jesli jest wymagany) */
FILE *playback_file = NULL;     /* plik danych wejsciowych (jesli jest */           
                                /* wymagany) */
char *extended_fgets(char *, int, FILE *);

int main(int argc, char *argv[])
{
    char name[80];      /* szukane imie */
    char *save_file_name; /* nazwa pliku rejestru */
    char *playback_file_name; /* nazwa pliku danych wejsciowych */

    int lookup(char const *const name); /* szukane imie */

    while ((argc > 1) && (argv[1][0] == '-')) {
        switch (argv[1][1]) {
	    /* -S<plik>  okresla plik rejestru */
            case 'S':
                save_file_name = &argv[1][2];
                save_file = fopen(save_file_name, "w");
                if (save_file == NULL) 
                    fprintf(stderr,
                      "Ostrzezenie:Nie mozna otworzyc pliku rejestru %s\n",
                        save_file_name);
                break;
	    /* -P<plik>  okresla plik danych wejsciowych */
            case 'P':
                playback_file_name = &argv[1][2];
                playback_file = fopen(playback_file_name, "r");
                if (playback_file == NULL) {
                    fprintf(stderr,
                      "Blad: Nie mozna otworzyc pliku danych wejsciowych %s\n",
                        playback_file_name);
                    exit (8);
                }
                break;
            default:
                fprintf(stderr," Nieprawidlowa opcja: %s\n", argv[1]);
                exit (8);
        }
        --argc;
        ++argv;
    }    

    /* ... Reszta programu ... */
    return (0);
}
