// Projekt: Jump_Search.cbp
// Plik   : Jump_Search.cpp

#include <iostream>
#include <cmath>

using namespace std;

int LinearSearch(
    int arr[],
    int startIndex,
    int endIndex,
    int val)
{
    // Iteruje od indeksu pocztkowego
    // do kocowego i zwraca
    // indeks wyszukiwanej wartoci.
    for(int i = startIndex; i < endIndex; ++i)
    {
        if(arr[i] == val)
        {
            return i;
        }
    }

    // W przypadku, gdyby nie znaleziono adnej wartoci:
    return -1;
}

int JumpSearch(
   int arr[],
   int arrSize,
   int val)
{
   // Nie jest moliwe wyszukanie wartoci
   // w tablicy zawierajcej zero lub mniej elementw.
   if (arrSize <= 0)
   {
      return -1;
   }

   // Definiuje progi przeskokw.
   int step = sqrt(arrSize);

   // Rozpoczyna porwnywanie od indeksu zerowego.
   int blockIndex = 0;

   // Zwiksza blockIndex o warto progu,
   // jeli blockIndex jest niszy ni dugo tablicy,
   // a warto elementu w blockIndex
   // wci jest nisza od wyszukiwanej wartoci.
   while (blockIndex < arrSize && arr[blockIndex] < val)
   {
      blockIndex += step;
   }

   // Po znalezieniu blockIndex
   // wykonuje LinearSearch()na podtablicy,
   // okrelonej wartoci blockIndex
   // arr[blockIndex - step ... blockIndex lub arrSize].
   return LinearSearch(
      arr,
      blockIndex - step,
      min(blockIndex, arrSize),
      val);
}

int main()
{
   cout << "Wyszukiwanie skokowe" << endl;

   // Inicjalizuje now tablic.
   int arr[] = {8, 15, 23, 28, 32, 39, 42, 44, 47, 48};
   int arrSize = sizeof(arr)/sizeof(*arr);

   // Definiuje warto do wyszukania.
   int searchedValue = 39;

   // Wyszukuje wskazan warto przy uyciu JumpSearch().
   int i = JumpSearch(arr, arrSize, searchedValue);

   // Powiadamia uytkownika o wyniku,
   // jeeli wyszukiwana warto zostaa znaleziona
   // i funkcja nie zwrcia wyniku -1.
   if(i != -1)
   {
      cout << searchedValue << " znaleziono w indeksie ";
      cout << i << endl;
   }
   else
   {
      cout << "Nie znaleziono wartoci " << searchedValue;
      cout << endl;
   }

   return 0;
}
