// Project: Deque.cbp
// File   : Deque.h
#ifndef DEQUE_H
#define DEQUE_H

#include "../../Node/DoublyNode.h"

template <typename T>
class Deque
{
private:
    int m_count;
    DoublyNode<T> * m_front;
    DoublyNode<T> * m_back;

public:
    Deque();
    bool IsEmpty();
    T Front();
    T Back();
    void EnqueueFront(T val);
    void EnqueueBack(T val);
    void DequeueFront();
    void DequeueBack();
};

template <typename T>
Deque<T>::Deque() : m_count(0), m_front(NULL), m_back(NULL) {}

template <typename T>
bool Deque<T>::IsEmpty()
{
    // Zwraca true, jeli nie ma adnych elementw; w przeciwnym przypadku zwraca false.
    return m_count <= 0;
}

template <typename T>
T Deque<T>::Front()
{
    // Zwraca warto wza m_front.
    return m_front->Value;
}

template <typename T>
T Deque<T>::Back()
{
    // Zwraca warto wza m_back.
    return m_back->Value;
}

template <typename T>
void Deque<T>::EnqueueFront(T val)
{
    // Tworzy nowy wze.
    DoublyNode<T> * node = new DoublyNode<T>(val);

    // Biecy m_front przestaje by m_front, wic wskanik Next nowego wza wskazuje biecy m_front.
    node->Next = m_front;

    // Jeli biecy m_front istnieje, wskanik Previous biecego m_front powinien wskazywa wze.
    if(m_front != NULL)
        m_front->Previous = node;

    // Nowy wze staje si m_front.
    m_front = node;

    // Jeli kolejka dwukierunkowa jest pusta, m_back jest tosamy z m_front.
    if(m_count == 0)
        m_back = m_front;

    // Dodaje element.
    m_count++;
}

template <typename T>
void Deque<T>::EnqueueBack(T val)
{
    // Jeli kolejka jest pusta, wywouje metod EnqueueFront().
    if(m_count == 0)
    {
        EnqueueFront(val);
        return;
    }

    // Tworzy nowy wze.
    DoublyNode<T> * node = new DoublyNode<T>(val);

    // Biecy m_back przestaje by m_back, wic wskanik Next biecego m_back 
    // bdzie wskazywa nowy wze.

    m_back->Next = node;

    // Wskanik Previous nowego wza powinien wskazywa biecy m_back.
    node->Previous = m_back;

    // Nowy wze staje si m_back.
    m_back = node;

    // Dodaje element.
    m_count++;
}

template <typename T>
void Deque<T>::DequeueFront()
{
    // Nic nie robi, jeli kolejka dwukierunkowa jest pusta.
    if(m_count == 0)
        return;

    // Zapisuje biecy m_front w nowym wle.
    DoublyNode<T> * node = m_front;

    // Wskanik m_front wskazuje element nastpujcy po biecym m_front.
    m_front = m_front->Next;

    // Mona bezpiecznie usun pierwszy element.
    delete node;

    // Jeli w kolejce dwukierunkowej znajduje si jakikolwiek element, wskanik Previous m_front powinien wskazywa NULL.
    if(m_front != NULL)
        m_front->Previous = NULL;

    // Usuwa element.
    m_count--;
}

template <typename T>
void Deque<T>::DequeueBack()
{
    // Nic si nie dzieje, jeli kolejka dwukierunkowa jest pusta.
    if(m_count == 0)
        return;

    // Jeli w kolejce dwukierunkowej znajduje si tylko jeden element, wywouje funkcj DequeueFront().
    if(m_count == 1)
    {
        DequeueFront();
        return;
    }

    // Zapisuje biecy m_back w nowym wle.
    DoublyNode<T> * node = m_back;

    // Wskanik m_back wskazuje element poprzedzajcy biecy m_back.
    m_back = m_back->Previous;

    // Nowy wskanik Next nowego m_back wskazuje NULL, poniewa chcemy usun ostatni element.
    m_back->Next = NULL;

    // Mona bezpiecznie usun ostatni element.
    delete node;

    // Usuwa element.
    m_count--;
}

#endif // DEQUE_H
