// Projekt: Subsequence_String.cbp
// Plik   : Subsequence_String.cpp

#include <iostream>

using namespace std;

bool IsSubSequence(
   string str1,
   string str2,
   int x,
   int y)
{
   // Jeli wszystkie znaki w str1
   // zostay sprawdzone,
   // oznacza to, e str1 to podsekwencja
   // cigu str2.
   if (x == 0)
   {
      return true;
   }

   // Jeli niektre znaki z str2
   // nie s zgodne z str1,
   // wic zwraca false.
   if (y == 0)
   {
      return false;
   }

   // Jeli ostatnie znaki dwch cigw s zgodne,
   // kontynuuje sprawdzanie kolejnych.
   if (str1[x - 1] == str2[y - 1])
   {
      return IsSubSequence(str1, str2, x - 1, y - 1);
   }
   // Jeli nie, sprawdza przedostatni znak str2.
   else
   {
      return IsSubSequence(str1, str2, x, y - 1);
   }
}

int main()
{
   setlocale( LC_ALL, "" );
   
   cout << "Cig podsekwencji" << endl;
   cout << "Sprawdza, czy pierwszy cig ";
   cout << "jest podsekwencj drugiego cigu" << endl;

   // Wprowadza pierwszy cig.
   string string1;
   cout << "Pierwszy cig wejciowy -> ";
   getline(cin, string1);

   // Wprowadza drugi cig.
   string string2;
   cout << "Drugi cig wejciowy -> ";
   getline(cin, string2);

   // Sprawdza, czy str1 jest podsekwencj str2.
   cout << "'" << string1 << "' to ";
   if(IsSubSequence(
      string1,
      string2,
      string1.size(),
      string2.size()))
   {
      cout << "podsekwencja";
   }
   else
   {
      cout << "NIE podsekwencja";
   }
   cout << " cigu '" << string2;
   cout << "'" << endl;

   return 0;
}
