// Projekt: Exponential_Search.cbp
// Plik   : Exponential_Search.cpp

#include <iostream>

using namespace std;

int BinarySearch(
   int arr[],
   int startIndex,
   int endIndex,
   int val)
{
   // Przeprowadza wyszukiwanie tylko wtedy,
   // kiedy indeks kocowy jest wikszy
   // od indeksu startowego lub jemu rwny.
   if(startIndex <= endIndex)
   {
      // Wyszukuje indeks rodkowy.
      int middleIndex = startIndex + (endIndex - startIndex) / 2;

      // Zwraca indeks, jeli warto indeksu rodkowego
      // jest rwna wyszukiwanej wartoci.
      if(arr[middleIndex] == val)
      {
         return middleIndex;
      }
      // Jeli warto indeksu rodkowego jest wysza od wyszukiwanej wartoci,
      // wykonuje kolejne wyszukiwanie binarne w lewej podtablicy.
      // arr[startIndex ... middleIndex - 1]
      else if(arr[middleIndex] > val)
      {
         return BinarySearch(arr, startIndex, middleIndex - 1, val);
      }
      // Jeli warto indeksu rodkowego jest nisza od wyszukiwanej wartoci,
      // wykonuje kolejne wyszukiwanie binarne w prawej podtablicy.
      // arr[middleIndex + 1 ... endIndex]
      else
      {
         return BinarySearch(arr, middleIndex + 1, endIndex, val);
      }
   }

   // W przypadku, gdyby nie znaleziono adnej wartoci:
   return -1;
}

int ExponentialSearch(
   int arr[],
   int arrSize,
   int val)
{
   // Nie jest moliwe wyszukanie wartoci
   // w tablicy zawierajcej zero lub mniej elementw.
   if (arrSize <= 0)
   {
      return -1;
   }

   // Zaczyna porwnywanie od indeksu 1.
   int blockIndex = 1;

   // Zwiksza blockIndex wykadniczo,
   // jeli blockIndex jest mniejszy od dugoci tablicy,
   // a warto elementu w blockIndex
   // wci jest nisza od wartoci wyszukiwanej.
   while (blockIndex < arrSize && arr[blockIndex] < val)
   {
      blockIndex *= 2;
   }

   // Po znalezieniu blockIndex
   // wykonuje funkcj BinarySearch() na podtablicy
   // okrelonej indeksami
   // arr[blockIndex / 2 ... blockIndex lub arrSize].
   return BinarySearch(
      arr,
      blockIndex / 2,
      min(blockIndex, arrSize),
      val);
}

int main()
{
   setlocale( LC_ALL, "" );
   
   cout << "Wyszukiwanie wykadnicze" << endl;

   // Inicjalizuje now tablic.
   int arr[] = {8, 15, 23, 28, 32, 39, 42, 44, 47, 48};
   int arrSize = sizeof(arr)/sizeof(*arr);

   // Definiuje warto do wyszukania.
   int searchedValue = 39;

   // Wyszukuje wskazan warto przy uyciu funkcji ExponentialSearch().
   int i = ExponentialSearch(arr, arrSize, searchedValue);

   // Powiadamia uytkownika o wyniku,
   // jeeli wyszukiwana warto zostaa znaleziona
   // i funkcja nie zwrcia wyniku -1.
   if(i != -1)
   {
      cout << searchedValue << " znaleziono w indeksie ";
      cout << i << endl;
   }
   else
   {
      cout << "Nie znaleziono wartoci " << searchedValue;
      cout << endl;
   }

   return 0;
}
