// Projekt: Selection_Sort.cbp
// Plik: Selection_Sort.cpp

#include <iostream>

using namespace std;

void SelectionSort(int arr[], int arrSize)
{
   // Zmienna przechowuje indeks elementu o najmniejszej wartoci w kadej iteracji.
   int minIndex;

   // Iteruje, a w licie pozostanie n  1 elementw.
   for(int i = 0; i < arrSize - 1; ++i)
   {
      // Wskazuje pierwszy nieposortowany element jako warto minimaln.
      minIndex = i;

      // Iteruje wycznie po nieposortowanych elementach.
      for(int j = i + 1; j < arrSize; ++j)
      {
         // Okrela now warto minimaln, jeli zapisana warto minimalna jest wiksza od wartoci biecego indeksu.
         if (arr[j] < arr[minIndex])
            minIndex = j;
      }

      // Zamienia pierwszy nieposortowany element z wartoci minimaln.
      swap(arr[i], arr[minIndex]);
   }
}

int main()
{
   setlocale( LC_ALL, "" );
   
   cout << "Sortowanie przez wybieranie" << endl;

   // Inicjalizuje now tablic.
   int arr[] = {43, 21, 56, 78, 97, 30};
   int arrSize = sizeof(arr)/sizeof(*arr);

   // Wywietla tablic wejciow.
   cout << "Tablica wejciowa: ";
   for (int i = 0; i < arrSize; ++i)
      cout << arr[i] << " ";
   cout << endl;

   // Sortuje tablic algorytmem SelectionSort.
   SelectionSort(arr, arrSize);

   // Wywietla posortowan tablic.
   cout << "Posortowana tablica: ";
   for (int i = 0; i < arrSize; ++i)
   cout << arr[i] << " ";
   cout << endl;

   return 0;
}
