// Projekt: Merge_Sort.cbp
// Plik   : Merge_Sort.cpp

#include <iostream>

using namespace std;

void Merge(
   int arr[],
   int startIndex,
   int middleIndex,
   int endIndex)
{
   // Liczba elementw od startIndex do endIndex,
   // ktre zostan posortowane.
   int totalElements = endIndex - startIndex + 1;

   // Tymczasowa tablica do przechowywania scalonych tablic.
   int * tempArray = new int[totalElements];

   // Indeks podtablicy znajdujcej si z lewej.
   // arr[startIndex ... middleIndex]
   int leftIndex = startIndex;

   // Indeks podtablicy znajdujcej si z prawej.
   // arr[middleIndex + 1 ... endIndex]
   int rightIndex = middleIndex + 1;

   // Indeks scalonej tablicy.
   int mergedIndex = 0;

   // Scala obie podtablice.
   while (leftIndex <= middleIndex && rightIndex <= endIndex)
   {
      if(arr[leftIndex] <= arr[rightIndex])
      {
         // Przechowuje element podtablicy po lewej,
         // jeeli ma nisz warto od elementu po prawej.
         tempArray[mergedIndex] = arr[leftIndex];

         // Przechodzi do kolejnego indeksu podtablicy po lewej.
         ++leftIndex;
      }
      else
      {
         // Przechowuje element podtablicy po prawej,
         // jeeli ma nisz warto od elementu po lewej.
         tempArray[mergedIndex] = arr[rightIndex];

         // Przechodzi do kolejnego indeksu podtablicy po prawej.
         ++rightIndex;
      }

      // Przechodzi do kolejnego indeksu scalonej tablicy.
      ++mergedIndex;
   }

   // Jeli w podtablicy po lewej zosta jaki element,
   // ktry nie zosta jeszcze zapisany w scalonej tablicy:
   while (leftIndex <= middleIndex)
   {
      tempArray[mergedIndex] = arr[leftIndex];

      // Przechodzi do kolejnego indeksu podtablicy po lewej.
      ++leftIndex;

      // Przechodzi do kolejnego indeksu scalonej tablicy.
      ++mergedIndex;
   }

   // Jeli w podtablicy po prawej zosta jaki element,
   // ktry nie zosta jeszcze zapisany w scalonej tablicy:
   while (rightIndex <= endIndex)
   {
      tempArray[mergedIndex] = arr[rightIndex];

      // Przechodzi do kolejnego indeksu podtablicy po prawej.
      ++rightIndex;

      // Przechodzi do kolejnego indeksu scalonej tablicy.
      ++mergedIndex;
   }

   // Po posortowaniu scalonej tablicy
   // kopiuje elementy do pierwotnej tablicy.
   for (int i = 0; i < totalElements; ++i)
   {
      arr[startIndex + i] = tempArray[i];
   }

   // Usuwa tymczasow tablic tempArray.
   delete[] tempArray;

   return;
}

void MergeSort(
   int arr[],
   int startIndex,
   int endIndex)
{
   // Wykonuje sortowanie tylko wtedy,
   // kiedy indeks kocowy jest wikszy od pocztkowego.
   if(startIndex < endIndex)
   {
      // Znajduje indeks rodkowy.
      int middleIndex = (startIndex + endIndex) / 2;

      // Sortuje podtablic po lewej.
      // arr[startIndex ... middleIndex]
      MergeSort(arr, startIndex, middleIndex);

      // Sortuje podtablic po prawej.
      // arr[middleIndex + 1 ... endIndex]
      MergeSort(arr, middleIndex + 1, endIndex);

      // Scala obie podtablice.
      Merge(arr, startIndex, middleIndex, endIndex);
   }

   return;
}

int main()
{
   setlocale( LC_ALL, "" );
   
   cout << "Sortowanie przez scalanie" << endl;

   // Inicjalizuje now tablic.
   int arr[] = {7, 1, 5, 9, 3, 6, 8, 2};
   int arrSize = sizeof(arr)/sizeof(*arr);

   // Wywietla tablic wejciow.
   cout << "Tablica wejciowa: ";
   for (int i=0; i < arrSize; ++i)
      cout << arr[i] << " ";
   cout << endl;

   // Sortuje tablic algorytmem MergeSort.
   MergeSort(arr, 0, arrSize - 1);

   // Wywietla posortowan tablic.
   cout << "Posortowana tablica: ";
   for (int i=0; i < arrSize; ++i)
      cout << arr[i] << " ";
   cout << endl;

   return 0;
}

