// Projekt: Insertion_Sort.cbp
// Plik: Insertion_Sort.cpp

#include <iostream>

using namespace std;

void InsertionSort(int arr[], int arrSize)
{
   // Iteruje po wszystkich elementach tablicy.
   for(int i = 0; i < arrSize; ++i)
   {
      // Okrela biecy element
      // jako warto odniesienia.
      int refValue = arr[i];

      // Zmienna suca do przenoszenia elementu
      // na waciw pozycj.
      int j;

      // Iteruje po posortowanych elementach,
      // eby umieci warto odniesienia
      // na waciwej pozycji.
      for(j = i - 1; j >= 0; --j)
      {
         // Jeli warto biecego indeksu
         // jest wiksza ni warto odniesienia,
         // przenosi biec warto na praw stron.
         // W przeciwnym wypadku umieszcza warto odniesienia
         // w biecym indeksie.
         if(arr[j] > refValue)
            arr[j+1] = arr[j];
         else
            break;
      }

      // Ten wiersz umieszcza warto odniesienia
      // w biecym indeksie (waciwej pozycji).
      arr[j + 1] = refValue;
   }
}

int main()
{
   setlocale( LC_ALL, "" );
   cout << "Sortowanie przez wstawianie" << endl;

   // Inicjalizuje now tablic.
   int arr[] = {43, 21, 26, 38, 17, 30};
   int arrSize = sizeof(arr)/sizeof(*arr);

   // Wywietla tablic wejciow.
   cout << "Tablica wejciowa: ";
   for (int i=0; i < arrSize; ++i)
      cout << arr[i] << " ";
   cout << endl;

   // Sortuje tablic przy uyciu algorytmu InsertionSort.
   InsertionSort(arr, arrSize);

   // Wywietla posortowan tablic.
   cout << "Posortowana tablica: ";
   for (int i=0; i < arrSize; ++i)
      cout << arr[i] << " ";
   cout << endl;

   return 0;
}
