// Projekt: Bubble_Sort.cbp
// Plik: Bubble_Sort.cpp

#include <iostream>

using namespace std;

void BubbleSort(int arr[], int arrSize)
{
   // Oznacza zamian elementw miejscami.
   bool isSwapped;

   // Zmniejsza warto
   // przy kadym posortowaniu elementw.
   int unsortedElements = arrSize;
   do
   {
      // Jelli co najmniej dwa elementy zostay zamienione
      // zmienna ma warto true.
      isSwapped = false;

      // Iteruje po elementach tablicy.
      for(int i = 0; i < unsortedElements - 1; ++i)
      {
         if (arr[i] > arr[i+1])
         {
            swap(arr[i], arr[i+1]);
            isSwapped = true;
         }
      }

      // Po ukoczeniu iteracji ostatni element zostaje posortowany,
      // wic jest pomijany przy kolejnej iteracji.
      --unsortedElements;
   }
   // Ponownie porwnuje elementy, jeli ktre zostay zamienione;
   // w przeciwnym wypadku uznaje, e lista zostaa posortowana.
   while(isSwapped);
}

int main()
{
   setlocale( LC_ALL, "" );
   
   cout << "Sortowanie bbelkowe" << endl;

   // Inicjalizuje now tablic.
   int arr[] = {43, 21, 26, 38, 17, 30};
   int arrSize = sizeof(arr)/sizeof(*arr);

   // Wywietla tablic wejciow.
   cout << "Tablica wejciowa: ";
   for (int i=0; i < arrSize; ++i)
      cout << arr[i] << " ";
   cout << endl;

   // Sortuje tablic przy uyciu algorytmu BubbleSort.
   BubbleSort(arr, arrSize);

   // Wywietla posortowan tablic.
   cout << "Posortowana tablica: ";
   for (int i=0; i < arrSize; ++i)
      cout << arr[i] << " ";
   cout << endl;

   return 0;
}
