#include "AVLNode.h"

AVL::AVL() : root(NULL)
{
}

int AVL::GetHeight(BSTNode * node)
{
    // Zwraca wysoko (Height) wza.
    // Zwraca -1, jeli wze jest NULL.
    return node == NULL ?
        -1 :
        node->Height;
}

BSTNode * AVL::RotateLeft(BSTNode * node)
{
    // Wze musi mie prawe dziecko.

    // Tworzy wze, ktry bdzie wywaonym wzem.
    BSTNode * balancedNode = node->Right;

    // Wywaony wze zastpi biecy wze.
    balancedNode->Parent = node->Parent;

    // Biecy wze stanie si dzieckiem wywaonego wza.
    node->Parent = balancedNode;

    // Prawe dziecko biecego wza bdzie lewym dzieckiem wywaonego wza.
    node->Right = balancedNode->Left;

    // Jeli wywaony wze ma lewe dziecko, kieruje rodzica do biecego wza.
    if (balancedNode->Left != NULL)
        balancedNode->Left->Parent = node;

    // Lewe dziecko wywaonego wza staje si biecym wzem.
    balancedNode->Left = node;

    // Odwiea wysoko wza.
    node->Height = std::max(
        GetHeight(node->Left),
        GetHeight(node->Right)) + 1;

    // Odwiea wysoko wywaonego wza.
    balancedNode->Height = std::max(
        GetHeight(balancedNode->Left),
        GetHeight(balancedNode->Right)) + 1;

    // Zwraca wze balancedNode.
    return balancedNode;
}

BSTNode * AVL::RotateRight(BSTNode * node)
{
    // Wze musi mie lewe dziecko.

    // Tworzy wze, ktry bdzie wywaonym wzem.
    BSTNode * balancedNode = node->Left;

    // Wywaony wze zastpi biecy wze.
    balancedNode->Parent = node->Parent;

    // Biecy wze stanie si dzieckiem wywaonego wza.
    node->Parent = balancedNode;

    // Lewe dziecko biecego wza bdzie prawym dzieckiem wywaonego wza.
    node->Left = balancedNode->Right;

    // Jeli wywaony wze ma prawe dziecko, kieruje rodzica do biecego wza.
    if (balancedNode->Right != NULL)
        balancedNode->Right->Parent = node;

    // Prawe dziecko wywaonego wza staje si biecym wzem.
    balancedNode->Right = node;

    // Odwiea wysoko wza.
    node->Height = std::max(
        GetHeight(node->Left),
        GetHeight(node->Right)) + 1;

    // Odwiea wysoko wywaonego wza.
    balancedNode->Height = std::max(
        GetHeight(balancedNode->Left),
        GetHeight(balancedNode->Right)) + 1;

    // Zwraca wze balancedNode.
    return balancedNode;
}

BSTNode * AVL::Insert(BSTNode * node, int key)
{
    // Jeli drzewo AVL nie istnieje, tworzy nowy wze jako korze.
    // Jeli wze nie ma dziecka, mona w takim miejscu wstawi nowy wze.
    if (node == NULL)
    {
        node = new BSTNode;
        node->Key = key;
        node->Left = NULL;
        node->Right = NULL;
        node->Parent = NULL;
        node->Height = 0;
    }
    // Jeli warto wskazanego klucza jest wiksza od wartoci klucza wza, przechodzimy do prawego poddrzewa.
    else if(node->Key < key)
    {
        node->Right = Insert(node->Right, key);
        node->Right->Parent = node;
    }
    // Jeli warto wskazanego klucza jest mniejsza od wartoci klucza wza, przechodzimy do lewego poddrzewa.
    else
    {
        node->Left = Insert(node->Left, key);
        node->Left->Parent = node;
    }

    // Sprawdza rwnowag.
    int balance =
        GetHeight(node->Left) - GetHeight(node->Right);

    // Jeli lewa strona jest cisza:
    if (balance == 2)
    {
        // Pobiera wysoko lewego poddrzewa.
        int balance2 =
            GetHeight(node->Left->Left) -
            GetHeight(node->Left->Right);

        if (balance2 == 1)
        {
            node = RotateRight(node);
        }
        else
        {
            node->Left = RotateLeft(node->Left);
            node = RotateRight(node);
        }
    }
    // Jeli prawa strona jest cisza:
    else if (balance == -2)
    {
        // Pobiera wysoko prawego poddrzewa.
        int balance2 =
            GetHeight(node->Right->Left) -
            GetHeight(node->Right->Right);

        if (balance2 == -1)
            node = RotateLeft(node);
        else
        { // 1
            node->Right = RotateRight(node->Right);
            node = RotateLeft(node);
        }
    }

    // Odwiea wysoko wza.
    node->Height = std::max(
        GetHeight(node->Left),
        GetHeight(node->Right)) + 1;

    // Zwraca zaktualizowane drzewo AVL.
    return node;
}

void AVL::Insert(int v)
{
    root = Insert(root, v);
}

BSTNode * AVL::Remove(BSTNode * node, int key)
{
    // Wskazany wze nie zosta znaleziony w drzewie AVL.
    if (node == NULL)
        return NULL;

    // Znaleziono wskazany wze.
    if (node->Key == key)
    {
        // Jeli wze jest liciem, mona go bezpiecznie usun.
        if (node->Left == NULL && node->Right == NULL)
            node = NULL;
        // Jeli wze ma tylko jedno dziecko po prawej:
        else if (node->Left == NULL && node->Right != NULL)
        {
            // Jedyne dziecko zostaje bezporednio podczone do rodzica swojego rodzica.
            node->Right->Parent = node->Parent;

            // Pomija wze.
            node = node->Right;
        }
        // Jeli wze ma tylko jedno dziecko po lewej:
        else if (node->Left != NULL && node->Right == NULL)
        {
            // Jedyne dziecko zostaje bezporednio podczone do rodzica swojego rodzica.
            node->Left->Parent = node->Parent;

            // Pomija wze.
            node = node->Left;
        }
        // Jeli wze ma dwoje dzieci (lewe i prawe):
        else
        {
            // Wyszukuje nastpnik i poprzednik, aby unikn bdu.
            int successorKey = Successor(key);

            // Zastpuje klucz wza kluczem nastpnika.
            node->Key = successorKey;

            // Usuwa klucz starego nastpnika.
            node->Right = Remove(node->Right, successorKey);
        }
    }
    // Jeli warto klucza docelowego wza jest mniejsza od wartoci podanego klucza, szukanie odbywa si w prawo:
    else if (node->Key < key)
        node->Right = Remove(node->Right, key);
    // Jeli warto klucza docelowego wza jest wiksza od wartoci podanego klucza, szukanie odbywa si w lewo:
    else
        node->Left = Remove(node->Left, key);

    // Wykonuje rotacj, tylko jeli wze nie jest NULL.
    if (node != NULL)
    {
        // Sprawdza rwnowag.
        int balance =
            GetHeight(node->Left) - GetHeight(node->Right);

        // Jeli lewa strona jest cisza:
        if (balance == 2)
        {
            // Pobiera wysoko lewego poddrzewa.
            int balance2 =
                GetHeight(node->Left->Left) -
                GetHeight(node->Left->Right);

            if (balance2 == 1)
            {
                node = RotateRight(node);
            }
            else
            {
                node->Left = RotateLeft(node->Left);
                node = RotateRight(node);
            }
        }
        // Jeli prawa strona jest cisza:
        else if (balance == -2)
        {
            // Pobiera wysoko prawego poddrzewa.
            int balance2 =
                GetHeight(node->Right->Left) -
                GetHeight(node->Right->Right);

            if (balance2 == -1)
                node = RotateLeft(node);
            else
            { // 1
                node->Right = RotateRight(node->Right);
                node = RotateLeft(node);
            }
        }

        // Odwiea wysoko wza.
        node->Height = std::max(
            GetHeight(node->Left),
            GetHeight(node->Right)) + 1;

    }

    // Zwraca zaktualizowane drzewo AVL.
    return node;
}

void AVL::Remove(int v)
{
    root = Remove(root, v);
}
