// Projekt: Binary_Tree.cbp
// Plik   : Binary_Tree.cpp

#include <iostream>

using namespace std;

class TreeNode
{
public:
    int Key;
    TreeNode * Left;
    TreeNode * Right;
};

TreeNode * NewTreeNode(
int key)
{
   // Tworzy nowy wze.
   TreeNode * node = new TreeNode;

   // Przypisuje klucz.
   node->Key = key;

   // Inicjalizuje wskaniki Left i Right.
   node->Left = NULL;
   node->Right = NULL;

   return node;
}

void PrintTreeInOrder(TreeNode * node)
{
	if(node == NULL) return;

	PrintTreeInOrder(node->Left);
	cout << node->Key << " ";
	PrintTreeInOrder(node->Right);
}

void Print (TreeNode * x, int & id)
{
    if (!x) return;

    Print (x->Left,id);

    id++;
    cout << id << ' ' << x->Key << endl;

    Print (x->Right,id);
}

int main()
{
    cout << "Binary Tree" << endl;

    // Tworzy element korzenia.
    TreeNode * root = NewTreeNode(1);

    /*
    Dodaje dzieci do korzenia.
           1
         /   \
        2     3
    */
    root->Left = NewTreeNode(2);
    root->Right = NewTreeNode(3);


    /*
    Dodaje dzieci do elementu 2
            1
         /     \
        2       3
      /   \
     4     5
    */

    root->Left->Left = NewTreeNode(4);
    root->Left->Right = NewTreeNode(5);

    /*
    Dodaje dzieci do elementu 3
            1
         /     \
        2       3
      /   \   /   \
     4     5 6     7
    */
    root->Right->Left = NewTreeNode(6);
    root->Right->Right = NewTreeNode(7);

    int id = 0;
    Print(root, id);

    return 0;
}
