// Projekt: Stack.cbp
// Plik   : Stack.h
#ifndef STACK_H
#define STACK_H

#include "../../Node/Node.h"

template <typename T>
class Stack
{
private:
    int m_count;
    Node<T> * m_top;

public:
    Stack();
    bool IsEmpty();
    T Top();
    void Push(T val);
    void Pop();
};

template <typename T>
Stack<T>::Stack() : m_count(0), m_top(NULL) {}

template <typename T>
bool Stack<T>::IsEmpty()
{
    // Zwraca true, jeli nie ma adnych elementw; w przeciwnym przypadku zwraca false.
    return m_count <= 0;
}

template <typename T>
T Stack<T>::Top()
{
    // Zwraca warto wza m_top.
    return m_top->Value;
}

template <typename T>
void Stack<T>::Push(T val)
{
    // Tworzy nowy wze.
    Node<T> * node = new Node<T>(val);

    // Wskanik Next nowego wza wskazuje biecy wze m_top.
    node->Next = m_top;

    // Nowy wze staje si wzem m_top.
    m_top = node;

    // Dodaje element.
    m_count++;
}

template <typename T>
void Stack<T>::Pop()
{
    // Nic si nie dzieje, jeli stos jest pusty.
    if(IsEmpty())
        return;

    // Przygotowuje biecy m_top do usunicia.
    Node<T> * node = m_top;

    // Nowy wze m_top staje si wskanikiem Next biecego wza m_top.
    m_top = m_top->Next;

    // Mona bezpiecznie usun pierwszy element.
    delete node;

    // Usuwa element.
    m_count--;
}

#endif // STACK_H
