// Projekt: List.cbp
// Plik   : List.cpp
#include "List.h"

List::List(): m_count(0) {}

List::~List()
{
    delete[] m_items;
    m_items = NULL;
}

int List::Get(int index)
{
    // Sprawdza, czy index znajduje si poza zakresem.
    if(index < 0 || index > m_count)
        return -1;

    return m_items[index];
}

void List::Insert(int index, int val)
{
    // Sprawdza, czy index znajduje si poza zakresem.
    if(index < 0 || index > m_count)
        return;

    // Kopiuje biec tablic.
    int * oldArray = m_items;

    // Zwiksza dugo tablicy.
    m_count++;

    // Inicjalizuje now tablic.
    m_items = new int[m_count];

    // Umieszcza dane w nowej tablicy.
    for(int i=0, j=0; i < m_count; ++i)
    {
        if(index == i)
        {
            m_items[i] = val;
        }
        else
        {
            m_items[i] = oldArray[j];
            ++j;
        }
    }

    // Usuwa skopiowan tablic.
    delete [] oldArray;
}

int List::Search(int val)
{
    // Ptla iterujca po elementach tablicy zwraca indeks elementu, jeli zosta znaleziony.
    for(int i=0; i < m_count; ++i)
    {
        if(m_items[i] == val)
        {
            return i;
        }
    }

    return -1;
}

void List::Remove(int index)
{
    // Sprawdza, czy index znajduje si poza zakresem.
    if(index < 0 || index > m_count)
        return;

    // Kopiuje biec tablic.
    int * oldArray = m_items;

    // Zmniejsza dugo tablicy.
    m_count--;

    // Inicjalizuje now tablic.
    m_items = new int[m_count];

    // Wypenia now tablic i usuwa wskazany indeks.
    for(int i=0, j=0; i < m_count; ++i, ++j)
    {
        if(index == j)
        {
            ++j;
        }

        m_items[i] = oldArray[j];
    }

    // Usuwa skopiowan tablic.
    delete [] oldArray;
}

int List::Count()
{
    return m_count;
}
