// Assignment_Operator_Overload.cbp
#include <iostream>

using namespace std;

class Animal
{
protected:
    string m_name;

public:
    Animal(string name) : m_name(name)
    {

    }

    // Interfejs, ktry trzeba zaimplementowa w klasie pochodnej.
    virtual string MakeSound() = 0;

    string GetName()
    {
        return m_name;
    }

};

class Dog : public Animal
{
public:
    // Przekazuje argumenty konstruktora.
    Dog(string name) : Animal(name) {}

    // Przecia kopiujcy operator przypisania.
    void operator = (const Dog &D ) {
         m_name = D.m_name;
      }

    // Implementuje interfejs.
    string MakeSound() override
    {
        return "hau, hau!";
    }

};

int main()
{
	setlocale( LC_ALL, "" );
    Dog dog = Dog("buldog");
    cout << dog.GetName() << " szczeka: ";
    cout << dog.MakeSound() << endl;

    Dog dog2 = dog;
    cout << dog2.GetName() << " szczeka: ";
    cout << dog2.MakeSound() << endl;

    return 0;
}
