#include <iostream>
#include <vector>
#include <queue>

using namespace std;

class MinHeapNode
{
    public:
        // Wprowadza znak.
        char Data;

        // Czstotliwo wystpowania znaku.
        unsigned Frequency;

        // Lewe i prawe dziecko.
        MinHeapNode * LeftChild, * RightChild;

        // Konstruktor.
        MinHeapNode(char data, unsigned freq)
        {
            // Inicjalizuje lewe i prawe dziecko.
            LeftChild = NULL;
            RightChild = NULL;

            this->Data = data;
            this->Frequency = freq;
        }
};

class compare
{
    public:
        bool operator()(
            MinHeapNode * left,
            MinHeapNode * right)
        {
            return(
                left->Frequency > right->Frequency);
        }
};

void PrintCodes(MinHeapNode * root, string str)
{
    if (!root)
        return;

    if (root->Data != '$')
    {
        cout << root->Data << ": ";
        cout << str << endl;
    }

    PrintCodes(root->LeftChild, str + "0");
    PrintCodes(root->RightChild, str + "1");
}

void HuffmanCodes(char data[], int freq[], int dataSize)
{
    MinHeapNode * left, * right, * top;

    // Tworzy stos i umieszcza w nim wszystkie znaki z data[].
    priority_queue<MinHeapNode*, vector<MinHeapNode*>, compare> minHeap;

    for (int i = 0; i < dataSize; ++i)
        minHeap.push(new MinHeapNode(data[i], freq[i]));

    // Iteruje, dopki wielko stosu nie rwna si 1.
    while (minHeap.size() != 1)
    {
        // Zwraca ze stosu dwa elementy o najmniejszej czstotliwoci wystpowania.
        left = minHeap.top();
        minHeap.pop();

        right = minHeap.top();
        minHeap.pop();

        // Tworzy nowy wze wewntrzny o czstoci wystpowania rwnej sumie czstoci wystpowania dwch wzw. 
        // Sprawia, e dwa pobrane wzy staj si lewym i prawym dzieckiem nowego wza. 
        // Dodaje ten wze do stosu minimum. '$' jest specjaln wartoci dla wzw wewntrznych, ktra nie jest tutaj uyta.
        top = new MinHeapNode(
            '$', left->Frequency + right->Frequency);

        top->LeftChild = left;
        top->RightChild = right;

        minHeap.push(top);
    }

    // Wywietla kody Huffmana, uywajc powyszego drzewa.
    PrintCodes(minHeap.top(), "");
}

int main()
{
//    char arr[] = { 'a', 'e', 'i', 's', 't', ' ', 'n' };
//    int freq[] = { 10, 15, 12, 3, 4, 13, 1 };
    char arr[] = { 'a', 'b', 'c', 'd', 'e', 'f' };
    int freq[] = { 5, 9, 12, 13, 16, 45 };

    int size = sizeof(arr) / sizeof(arr[0]);

    HuffmanCodes(arr, freq, size);

    return 0;
}
