// Projekt: Hash_Table_SC.cbp
// Plik   : HashTable.cpp

#include "HashTable.h"

using namespace std;

HashTable::HashTable()
{
    for (int i = 0; i < TABLE_SIZE; ++i)
      tableList[i].clear();
}

int HashTable::HashFunction(int key)
{
    return key % TABLE_SIZE;
}

void HashTable::Insert(int key, string value)
{
    bool isKeyFound = false;

    // Pozyskuje klucz mieszajcy z funkcji mieszajcej.
    int hashKey = HashFunction(key);

    // Iteruje po acuchu wzw (licie wizanej) we wskazanej komrce.
    for (auto &keyValue : tableList[hashKey])
    {
        // Jeli klucz zosta znaleziony, aktualizuje dane.
        if (keyValue.first == key)
        {
            isKeyFound = true;
            keyValue.second = value;
        }
    }

    // Jeli klucz nie zosta znaleziony, umieszcza nowy klucz na kocu listy.
    if (!isKeyFound)
        tableList[hashKey].emplace_back(key, value);
}

string HashTable::Search(int key)
{
    // Pozyskuje klucz mieszajcy z funkcji mieszajcej.
    int hashKey = HashFunction(key);

    // Iteruje po acuchu wzw (licie wizanej) we wskazanej komrce.
    for (auto &keyValue : tableList[hashKey])
    {
        // Jeli klucz zosta znaleziony, zwraca warto nazwy.
        if (keyValue.first == key)
        {
            return keyValue.second;
        }
    }

    // Jeli funkcja dociera do tej instrukcji, oznacza to, e klucz nie zosta znaleziony, wic zwrcony zostaje pusty cig znakowy.
    return "";
}

void HashTable::Remove(int key)
{
    // Pozyskuje klucz mieszajcy z funkcji mieszajcej.
    int hashKey = HashFunction(key);

    // Pobiera komrk.
    auto &cell = tableList[hashKey];

    // Przechodzi po acuchu wzw (licie wizanej).
    for (auto it = cell.begin(); it != cell.end(); ++it)
    {
        // Jeli klucz zosta znaleziony, usuwa element z listy.
        if (it->first == key)
        {
            cell.erase(it);
            break;
        }
    }

    // Uwaga: nic si nie dzieje, jeli klucz nie zosta znaleziony.
}

bool HashTable::IsEmpty()
{
    // Inicjalizuje totalElement.
    int totalElement = 0;

    // Liczy wszystkie elementy w tablicy mieszajcej.
    for (int i = 0; i < TABLE_SIZE; ++i)
    {
        totalElement += (int)tableList[i].size();

        // Jeli suma elementw nie jest zerowa, tablica mieszajca nie moe by pusta.
        if (totalElement > 0)
            return false;
    }

    // Jeli funkcja dociera do tej instrukcji, oznacza to, e suma elementw jest zerowa.
    return true;
}
