// Projekt: Pattern_Searching.cbp
// Plik   : Pattern_Searching.cpp

#include <iostream>
#include <vector>

using namespace std;

vector<int> SearchPattern(
   string targetString,
   string patternString)
{
   vector<int> vecIndex;

   // Pobiera dugo cigu.
   int strLen = targetString.size();
   int patLen = patternString.size();

   // Wykonuje ponisz procedur tylko wtedy,
   // kiedy cig wzorca nie jest duszy ni
   // cig docelowy.
   if(patLen <= strLen)
   {
      // Iteruje po elementach cigu docelowego
      // od pocztku do ostatniego
      // moliwego elementu, od ktrego
      // wzorzec moe si zacz.
      for(int i = 0; i <= strLen - patLen; ++i)
      {
         int j;

         // Zaczyna porwnywanie cigu wzorca.
         for(j = 0; j < patLen; ++j)
         {
            // Przerywa wewntrzn ptl for,
            // jeli znak nie jest zgodny.
            if(targetString[i + j] !=
               patternString[j])
            {
               break;
            }
         }

         // Jeli wewntrzna ptla for zostaa ukoczona,
         // oznacza to, e znaleziono wzorzec
         // w cigu docelowym.
         if(j == patLen)
         {
            // Zapisuje indeks w wektorze.
            vecIndex.push_back(i);
         }
      }
   }

   // Zwraca wektor.
   return vecIndex;
}

int main()
{
   setlocale( LC_ALL, "" );
   cout << "Wyszukiwanie wzorca" << endl;

   // Wprowadza cig docelowy.
   string targetStr;
   cout << "Wejciowy cig docelowy -> ";
   getline(cin, targetStr);

   // Wprowadza cig wzorca.
   string patternStr;
   cout << "Wejciowy cig wzorca -> ";
   getline(cin, patternStr);

   // Znajduje wzorzec.
   vector<int> myvector = SearchPattern(
      targetStr,
      patternStr);

   // Zwraca uytkownikowi wynik.
   cout << "'" << patternStr << "' ";
   if(myvector.size() > 0)
   {
      cout << "zostao znalezione w indeksie ";
      for (
         vector<int>::iterator it = myvector.begin();
         it != myvector.end();
         ++it)
      {
         cout << *it << " ";
      }
   }
   else
   {
      cout << "NIE zostao znalezione";
   }
   cout << endl;

   return 0;
}
