// Projekt: Anagram.cbp
// Plik   : Anagram.cpp

#include <iostream>
#include <string>
#include <algorithm>

using namespace std;

bool IsAnagram(
   string str1,
   string str2)
{
   // Wielko znakw nie ma znaczenia,
   // wic przeksztacamy wszystkie litery
   // w wielkie.
   transform(
      str1.begin(),
      str1.end(),
      str1.begin(),
      ::toupper);
   transform(
      str2.begin(),
      str2.end(),
      str2.begin(),
      ::toupper);

   // Spacje nie s istotne,
   // wic usuwamy je, jeli s obecne.
   str1.erase(
      remove(
         str1.begin(),
         str1.end(),
         ' '),
         str1.end());
   str2.erase(
      remove(
         str2.begin(),
         str2.end(),
         ' '),
         str2.end());

   // Sortujemy nastpnie string1 i string2.
   sort(str1.begin(), str1.end());
   sort(str2.begin(), str2.end());

   // Jeli obydwa cigi s anagramami,
   // bd one jednakowe po posortowaniu.
   return str1 == str2;
}

int main()
{
   setlocale( LC_ALL, "" );
   
   cout << "Anagram" << endl;

   // Wprowadza string1.
   string string1;
   cout << "Pierwszy cig -> ";
   getline(cin, string1);

   // Wprowadza string2.
   string string2;
   cout << "Drugi cig -> ";
   getline(cin, string2);

   // Sprawdza, czy s anagramami.
   cout << "'" << string1 << "' i '";
   cout << string2 << "' to ";
   if(IsAnagram(string1, string2))
   {
      cout << "anagramy";
   }
   else
   {
      cout << "NIE anagramy";
   }
   cout << endl;

   return 0;
}
