// Projekt: Sublist_Search.cbp
// Plik   : Sublist_Search.cpp

#include <iostream>

using namespace std;

class Node
{
public:
    int Value;
    Node * Next;
};

void PrintNode(Node * node)
{
    // Zwraca kolejno wzy,
    // a trafi na Next o wartoci NULL,
    // wskazujcy koniec acucha wzw.
    while(node != NULL)
    {
        cout << node->Value << " -> ";
        node = node->Next;
    }

    cout << "NULL" << endl;
}

bool CompareAllMatchedElements(
   Node * ptr1,
   Node * ptr2)
{
   // ptr2 nie moe by NULL,
   // poniewa zostanie porwnany
   // z ptr1.
   if(ptr1 != NULL && ptr2 == NULL)
      return false;

   // Koniec pierwszego elementu listy.
   if(ptr1 == NULL)
      return true;

   // Porwnuje wartoci obydwu list.
   if(ptr1->Value == ptr2->Value)
   {
      // Porwnuje kolejny element.
      return CompareAllMatchedElements(
         ptr1->Next,
         ptr2->Next);
   }
   else
   {
      return false;
   }
}

bool SublistSearch(
   Node * firstList,
   Node * secondList)
{
   // Jeli obydwie s NULL,
   // zwraca warto true.
   if(firstList == NULL && secondList == NULL)
   {
      return true;
   }

   // Jeli tylko jedna jest NULL,
   // zwraca warto false.
   if((firstList != NULL && secondList == NULL) ||
       (firstList == NULL && secondList != NULL))
   {
      return false;
   }

   // Porwnuje wartoci, a jeli nie s zgodne,
   // sprawdza kolejny element drugiej listy.
   if (firstList->Value == secondList->Value)
   {
      // Jeli s zgodne, sprawdza kolejny element.
      if(CompareAllMatchedElements(
         firstList,
         secondList))
      {
         return true;
      }
   }

   // Sprawdza kolejny element pierwszej listy.
   return SublistSearch(firstList, secondList->Next);
}

int main()
{
   setlocale( LC_ALL, "" );
   
   cout << "Wyszukiwanie podlisty" << endl;

   // Inicjalizuje pierwsz list.
   // 23 -> 30 -> 41
   Node * node1_c = new Node();
   node1_c->Value = 41;
   Node * node1_b = new Node();
   node1_b->Value = 30;
   node1_b->Next = node1_c;
   Node * node1_a = new Node();
   node1_a->Value = 23;
   node1_a->Next = node1_b;

   // Wywietla pierwsz list.
   cout << "Pierwsza lista: ";
   PrintNode(node1_a);

   // Inicjalizuje drug list.
   // 10 -> 15 -> 23 -> 30 -> 41 -> 49
   Node * node2_f = new Node();
   node2_f->Value = 49;
   Node * node2_e = new Node();
   node2_e->Value = 41;
   node2_e->Next = node2_f;
   Node * node2_d = new Node();
   node2_d->Value = 30;
   node2_d->Next = node2_e;
   Node * node2_c = new Node();
   node2_c->Value = 23;
   node2_c->Next = node2_d;
   Node * node2_b = new Node();
   node2_b->Value = 15;
   node2_b->Next = node2_c;
   Node * node2_a = new Node();
   node2_a->Value = 10;
   node2_a->Next = node2_b;

   // Wywietla drug list.
   cout << "Druga lista: ";
   PrintNode(node2_a);

   // Powiadamia uytkownika o wyniku.
   // Jeli zwrcono warto true,
   // znaleziono wyszukiwan warto.
   cout << "Wynik: pierwsza lista ";
   if(SublistSearch(node1_a, node2_a))
   {
      cout << "zostaa znaleziona";
   }
   else
   {
   cout << "nie zostaa znaleziona";
   }
   cout << " w drugiej licie." << endl;

   return 0;
}
