// Projekt: Counting_Sort.cbp
// Plik   : Counting_Sort.cpp

#include <iostream>

using namespace std;

void CountingSort(int arr[], int arrSize)
{
    // Tworzy klucz (tablic zliczajc) przy zaoeniu, e wszystkie elementy maj wartoci od 0 do 9.
    int counterSize = 10;
    int * counterArray = new int [counterSize];

    // Zwiksza warto licznika o 1.
    for(int i = 0; i < arrSize; ++i)
    {
        ++counterArray[arr[i]];
    }

    // Licznik do iterowania po tablicy arrCounter.
    int arrCounter = 0;

    for(int i = 0; i < counterSize; ++i)
    {
        while(counterArray[i] > 0)
        {
            // Zwraca element do listy.
            arr[arrCounter++] = i;

            // Zmniejsza warto licznika o 1.
            --counterArray[i];
        }
    }
}

int main()
{
    setlocale( LC_ALL, "" );
   
    cout << "Sortowanie przez zliczanie" << endl;

    // Inicjalizuje now tablic.
    int arr[] = {9, 6, 5, 6, 1, 7, 2, 4, 3, 5, 7, 7, 9, 6};
    int arrSize = sizeof(arr)/sizeof(*arr);

    // Wywietla tablic wejciow.
    cout << "Initial array: ";
    for (int i=0; i < arrSize; ++i)
        cout << arr[i] << " ";
    cout << endl;

    // Sortuje tablic algorytmem BubbleSort.
    CountingSort(arr, arrSize);

    // Wywietla posortowan tablic.
    cout << "Sorted array : ";
    for (int i=0; i < arrSize; ++i)
        cout << arr[i] << " ";
    cout << endl;

    return 0;
}
