#include <iostream>
#include <string>

class MyClass {

public:
   MyClass( ) : ival_(0), sval_("bla") {}
  ~MyClass( ) {}

   void incr( ) {++ival_;}
   void decr( ) {ival_--;}

private:
   std::string sval_;
   int ival_;
};

int main( ) {

   MyClass obj;

   int         MyClass::* mpi = &MyClass::ival_;  // wskaniki skadowych
   std::string MyClass::* mps = &MyClass::sval_;  // klasy

   void (MyClass::*mpf)( ); // wskanik metody bezargumentowej i nie
                            // zwracajcej wartoci
   void (*pf)( );           // wskanik zwykej funkcji

   int* pi = &obj.ival_;   // wskanik typu int, wskazujcy na skadow 
                           // klasy typu int -- w porzdku

   mpf = &MyClass::incr;   // wskanik metody; jgo warto nie nadaje si do zapisu do
                           // strumienia; wtpliwoci mona rozwia przygldajc si 
                           // wskanikowi w debuggerze

   pf = &MyClass::incr;    // Bd: &MyClass::incr nie jest egzemplarzem funkcji

   std::cout << "wsk_sk1 = " << mpi << '\n';
   std::cout << "wsk_sk2 = " << mps << '\n';
   std::cout << "wsk =  " << pi << '\n';
   std::cout << "*wsk = " << *pi << '\n';

   obj.*mpi = 5;
   obj.*mps = "ple";

   (obj.*mpf)( ); // obj.ival_ to teraz 6

   std::cout << "obj.ival_ = " << obj.ival_ << '\n';
   std::cout << "obj.sval_ = " << obj.sval_ << '\n';
}