#include <fstream>
#include <boost/archive/xml_oarchive.hpp> // obiekt zapisu do archiwum XML
#include <boost/archive/xml_iarchive.hpp> // obiekt odczytu z archiwum XML
#include <boost/serialization/vector.hpp> // maszyneria serializacji
#include "animal.hpp"                     // std::vector

int main( )
{
    using namespace std;
    using namespace boost::archive;       // przestrze nazw archiww
    using namespace boost::serialization; // przestrze nazw make_nvp

    try {
        // wypenienie wektora obiektw Animal
        vector<Animal> animalList;
        animalList.push_back( 
            Animal( "Horacy", "so", "1992-04-23", 
                    Contact("Dr Jan Nowak", "(801)595-9627"),
                    Contact("Tomek Paluch", "(801)881-2260") ));
        animalList.push_back( 
            Animal( "Szelma", "papuga", "1998-09-30", 
                    Contact("Dr Kamil Rosomak", "(801)466-6498"),
                    Contact("Ela Danuta", "(801)929-2506") ));
        animalList.push_back( 
            Animal( "Dipi", "pingwin", "2001-06-08", 
                    Contact("Dr Barbara Nowicka", "(801)459-7746"),
                    Contact("Darek Zimny", "(801)882-3549") ));

        // skonstruowanie wyjciowego archiwum XML i utrwalenie w nim listy
        ofstream       fout("cyrk.xml");
        xml_oarchive   oa(fout);
        oa << make_nvp("animalList", animalList);
        fout.close( );

        // skonstruowanie wejciowego archiwum XML i odtworzenie listy
        ifstream        fin("cyrk.xml");
        xml_iarchive    ia(fin);
        vector<Animal>  animalListCopy;
        ia >> make_nvp("animalList", animalListCopy);
        fin.close( );

        if (animalListCopy != animalList) {
            cout << "Bd serializacji XML\n";
            return EXIT_FAILURE;
        }

    } catch (const exception& e) {
        cout << e.what( ) << "\n";
        return EXIT_FAILURE;
    }
}