#include <exception>
#include <iostream>     // cout
#include <xercesc/dom/DOM.hpp>
#include <xercesc/framework/LocalFileFormatTarget.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <pathan/XPathNamespace.hpp>
#include <pathan/XPathResult.hpp>
#include <pathan/XPathEvaluator.hpp>
#include <pathan/XPathExpression.hpp> 
#include "xerces_strings.hpp"  // listing 14.4

using namespace std;
using namespace xercesc;

/*
 * definicja klasy XercesInitializer jak na listingu 14.8
 * oraz klas CircusErrorHandler i DOMPtr jak na listingu 14.10
 */

int main( )
{
    try {
        // inicjalizacja infrastruktury Xerces i pozyskanie DOMImplementation
        XercesInitializer   init;
        DOMImplementation*  impl = 
            DOMImplementationRegistry::getDOMImplementation(
                fromNative("LS").c_str( )
            );
        if (impl == 0) {
            cout << "nie mona utworzy implementacji DOM\n";
            return EXIT_FAILURE;
        }

        // konsturkcja obiektu DOMBuilder do przetwarzania pliku cyrk.xml.
        DOMPtr<DOMBuilder>  parser = 
            static_cast<DOMImplementationLS*>(impl)->
                createDOMBuilder(
                    DOMImplementationLS::MODE_SYNCHRONOUS, 0
                );
        CircusErrorHandler  err;
        parser->setErrorHandler(&err);

        // przetwarzanie dokumentu
        DOMDocument*  doc = 
            parser->parseURI("cyrk.xml");
        DOMElement*   animalList = doc->getDocumentElement( );

        // utworzenie wyraenia XPath
        auto_ptr<XPathEvaluator>   
            evaluator(XPathEvaluator::createEvaluator( ));
        auto_ptr<XPathNSResolver>  
            resolver(evaluator->createNSResolver(animalList));
        auto_ptr<XPathExpression>  
            xpath(
                evaluator->createExpression(
                    fromNative(
                        "animalList/animal[child::name='Horacy']"
                    ).c_str( ),
                    resolver.get( )
                )
            );
auto_ptr<XPathEvaluator>   evaluator(XPathEvaluator::createEvaluator( ));
auto_ptr<XPathNSResolver>  resolver(evaluator->createNSResolver(animalList));
auto_ptr<XPathExpression>  xpath(
      evaluator->createExpression(
            fromNative("animalList/animal[child::name='Horacy']").c_str( ),
            resolver.get( )
      ));

        // ewaluacja wyraenia
        XPathResult* result = 
            xpath->evaluate(
                doc, 
                XPathResult::ORDERED_NODE_ITERATOR_TYPE, 
                0
            );

        DOMNode* horacy;
        if (horacy = result->iterateNext( )) {
            animalList->removeChild(horacy);
            horacy->release( ); // opcjonalnie
        }

        // konstrukcja obiektu DOMWriter do zapisu zmodyfikowanego dokumentu
        DOMPtr<DOMWriter> writer = 
            static_cast<DOMImplementationLS*>(impl)->createDOMWriter( );
        writer->setErrorHandler(&err);

        // zapisanie pliku cyrk2.xml.
        LocalFileFormatTarget file("cyrk2.xml");
        writer->writeNode(&file, *animalList);
    } catch (const DOMException& e) {
        cout << toNative(e.getMessage( )) << "\n";
        return EXIT_FAILURE;
    } catch (const XPathException &e) {
        cout << e.getString( ) << "\n";
        return EXIT_FAILURE;
    } catch (const exception& e) {
        cout << e.what( ) << "\n";
        return EXIT_FAILURE;
    }
}