/*
 * Jak na listingu 14.8, nie potrzebujemy jedynie nagwka <vector>
 */

#include <stdexcept> // runtime_error
#include <xercesc/sax2/DefaultHandler.hpp>

using namespace std;
using namespace xercesc;

/*
 * definicja klasy XercesInitializer jak na listingu 14.8
 * i klasy CircusErrorHandler jak na listingu 14.7
 */

int main( )
{
    try {
        // inicjalizacja infrastruktury Xerces i pozyskanie parsera SAX2
        XercesInitializer init;
        auto_ptr<SAX2XMLReader>  
           parser(XMLReaderFactory::createXMLReader( ));

        // wczenie walidacji dokumentu
        parser->setFeature(XMLUni::fgSAX2CoreValidation, true);

        // rejestracja obsugi bdw do odbioru 
        // powiadomie o naruszeniach DTD 
        CircusErrorHandler error;
        parser->setErrorHandler(&error);
        parser->parse("cyrk.xml");
    } catch (const SAXException& e) {
        cout << "bd xml: " << toNative(e.getMessage( )) << "\n";
        return EXIT_FAILURE;
    } catch (const XMLException& e) {
        cout << "bd xml: " << toNative(e.getMessage( )) << "\n";
        return EXIT_FAILURE;
    } catch (const exception& e) {
        cout << e.what( ) << "\n";
        return EXIT_FAILURE;
    }
}