#include <iostream>
#include <locale>
#include <string>

using namespace std;

string printPattern(moneypunct<char>::pattern& pat) {

   string s(pat.field);  // pat.field to tablica char[4]
   string r;

   for (int i = 0; i < 4; ++i) {
      switch (s[i]) {
      case moneypunct<char>::sign:
        r += "znak ";
        break;
      case moneypunct<char>::none:
        r += "brak ";
        break;
      case moneypunct<char>::space:
        r += "spacja ";
        break;
      case moneypunct<char>::value:
        r += "warto ";
        break;
      case moneypunct<char>::symbol:
        r += "symbol ";
        break;
      }
   }
   return(r);
}

int main( ) {

   locale loc("danish");

   const moneypunct<char>& punct =
     use_facet<moneypunct<char> >(loc);

   cout << "Przecinek dziesitny:      " << punct.decimal_point( ) << '\n'
        << "Separator tysiczny:       " << punct.thousands_sep( ) << '\n'
        << "Symbol waluty:             " << punct.curr_symbol( ) << '\n'
        << "Znak wartoci dodatniej:   " << punct.positive_sign( ) << '\n'
        << "Znak wartoci ujemnej:     " << punct.negative_sign( ) << '\n'
        << "Cyfry uamkowe:            " << punct.frac_digits( ) << '\n'
        << "Format wartoci dodatniej: "
        << printPattern(punct.pos_format( )) << '\n'
        << "Format wartoci ujemnej:   "
        << printPattern(punct.neg_format( )) << '\n';

   // format grupowania jest co prawda reprezentowany cigiem znakw, ale
   // kady z tych znakw interpretuje si przez jego warto liczbow,
   // okrelajc liczno odpowiedniej grupy
   string s = punct.grouping( );
   for (string::iterator p = s.begin( ); p != s.end( ); ++p)
      cout << "Grupowanie po:          " << (int)*p << '\n';
}