#include <stdexcept>
#include <iostream>
#include <iterator>

using namespace std;

template<class Value_T, class Iter_T>
Value_T computeMean(Iter_T first, Iter_T last) {
  if (first == last) throw domain_error("rednia niezdefiniowana");
  Value_T sum;
  int cnt = 0;
  while (first != last) {
    sum += *first++;
    ++cnt;
  }
  return sum / cnt;
}

int main( ) {
  cout << "podaj w kolejnych wierszach kilka liczb cakowitych;" << endl;
  cout << "szereg zakocz znakiem EOF (czyli kombinacj Ctrl+Z)" << endl;
  double mean = computeMean<double>(
    istream_iterator<int>(cin),
    istream_iterator<int>( ));
  cout << "rednia wynosi " << mean << endl;
}