template<typename T>
class MessageGeneric {

public:
   MessageGeneric(int bufSize = DEFAULT_BUF_SIZE) :
      bufSize_(bufSize),
      initBufSize_(bufSize),
      msgSize_(0),
      buf_(new T[bufSize]) {}

  ~MessageGeneric( ) {
      delete[] buf_;
   }

   void appendData(int len, const T* data) {
      if (msgSize_+len > MAX_SIZE) {
         throw out_of_range("Rozmiar danych przekracza limit.");
      }
      if (msgSize_+len > bufSize_) {

         int newBufSize = bufSize_;
         while ((newBufSize *= 2) < msgSize_+len);

         T* p = new T[newBufSize];

         copy(buf_, buf_+msgSize_, p);     // czy copy moe zrzuci wyjtek?
         copy(data, data+len, p+msgSize_);

         msgSize_ += len;
         bufSize_ = newBufSize;

         delete[] buf_;  // pozbycie si poprzedniego bufora i
         buf_ = p;       // przestawienie wskanika bufora na nowy
      }
      else {
         copy(data, data+len, buf_+msgSize_);
         msgSize_ += len;
      }
   }

   // kopiowanie danych do bufora wskazanego przez wywoujcego
   int getData(int maxLen, T* data) {
      if (maxLen < msgSize_) {
         throw out_of_range("Bufor docelowy nie pomieci danych.");
      }
      copy(buf_, buf_+msgSize_, data);
      return(msgSize_);
   }

private:
   MessageGeneric(const MessageGeneric& orig) {}
   MessageGeneric& operator=(const MessageGeneric& rhs) {}
   int bufSize_;
   int initBufSize_;
   int msgSize_;
   T* buf_;
};