class Message {

public:
   Message(int bufSize = DEFAULT_BUF_SIZE) :
      bufSize_(bufSize),
      initBufSize_(bufSize),
      msgSize_(0),
      buf_(NULL) {
      buf_ = new char[bufSize];
   }

  ~Message( ) {
      delete[] buf_;
   }

   // doczanie znakw
   void appendData(int len, const char* data) {
      if (msgSize_+len > MAX_SIZE) {
         throw out_of_range("Rozmiar danych przekracza limit.");
      }
      if (msgSize_+len > bufSize_) {

         int newBufSize = bufSize_;
         while ((newBufSize *= 2) < msgSize_+len);

         char* p = new char[newBufSize];    // przydzia pamici
                                            // dla nowego bufora

         copy(buf_, buf_+msgSize_, p);      // kopiowanie poprzedniej zawartoci
         copy(data, data+len, p+msgSize_);  // kopiowanie nowych danych

         msgSize_ += len;
         bufSize_ = newBufSize;

         delete[] buf_;  // pozbycie si poprzedniego bufora i 
         buf_ = p;       // przestawienie wskanika bufora na nowy
      }
      else {
         copy(data, data+len, buf_+msgSize_);
         msgSize_ += len;
      }
   }

   // kopiowanie danych do bufora wskazanego przez wywoujcego
   int getData(int maxLen, char* data) {
      if (maxLen < msgSize_) {
         throw out_of_range("Bufor docelowy nie pomieci danych.");
      }
      copy(buf_, buf_+msgSize_, data);
      return(msgSize_);
   }

private:
   Message(const Message& orig) {}           // por. receptur 9.5.
   Message& operator=(const Message& rhs) {} // 
   int bufSize_;
   int initBufSize_;
   int msgSize_;
   char* buf_;
};