#include <iostream>
#include <list>
#include <algorithm>
#include <string>

using namespace std;

static const int ARRAY_SIZE = 5;

template<typename T,
         typename FwdIter>
FwdIter fixOutliersUBound(FwdIter p1,
                          FwdIter p2,
                          const T& oldVal,
                          const T& newVal) {
   for ( ;p1 != p2; ++p1) {
      if (greater<T>(*p1, oldVal)) {
         *p1 = newVal;
      }
   }
}

int main( ) {

   list<string> lstStr;

   lstStr.push_back("Prosz");
   lstStr.push_back("zostawi");
   lstStr.push_back("wiadomo");
   lstStr.push_back(".");

   // utworzenie iteratora do przegldania listy
   for (list<string>::iterator p = lstStr.begin( );
        p != lstStr.end( ); ++p) {
      cout << *p << endl;
   }

   // albo iteratora wstecznego, sucego do przegldania w odwrotnym
   // kierunku (od koca do czoa listy); metoda rbegin zwraca iterator
   // wsteczny (reverse_iterator) ostatniego elementu listy; rend zwraca
   // iterator pozycji poprzedzajcej pozycj pierwszego elementu listy
   for (list<string>::reverse_iterator p = lstStr.rbegin( );
        p != lstStr.rend( ); ++p) {
      cout << *p << endl;
   }

   // przegldanie zakresu
   string arrStr[ARRAY_SIZE] = {"Tak", "mi", "dobrze", "tak", "wesoo"};

   for (string* p = &arrStr[0];
        p != &arrStr[ARRAY_SIZE]; ++p) {
      cout << *p << endl;
   }

   // uycie standardowego algorytmu ze standardow sekwencj
   list<string> lstStrDest;
   unique_copy(&arrStr[0], &arrStr[ARRAY_SIZE],
                    back_inserter(lstStrDest));
}
