# rozszerzenia nazw plikw do usunicia w ramach zadania clean
CLEANEXTS = o so

# pliki rdowe, zadania i katalog instalacyjny
SOURCES = george.cpp ringo.cpp georgeringo.cpp
OUTPUTFILE = libgeorgeringo.so
INSTALLDIR = ../binaries

.PHONY: all
all: $(OUTPUTFILE)

# kompilacja bibioteki libgeorgeringo.so z plikw george.o, ringo.o
# i georgeringo.o; subst to funkcja omawiana w recepturze 1.16,
# a suca do zastpowania podcigw w cigu
$(OUTPUTFILE): $(subst .cpp,.o,$(SOURCES))
	$(CXX) -shared -fPIC $(LDFLAGS) -o $@ $^

.PHONY: install
install:
	mkdir -p $(INSTALLDIR)
	cp -p $(OUTPUTFILE) $(INSTALLDIR)

.PHONY: clean
clean:
	for file in $(CLEANEXTS); do rm -f *.$$file; done

# generowanie zalenoci plikw .ccp files od plikw .hpp
include $(subst .cpp,.d,$(SOURCES))
%.d: %.cpp
	$(CC) -M $(CPPFLAGS) $< > $@.$$$$; \
	sed 's,\($*\)\.o[ :]*,\1.o $@ : ,g' < $@.$$$$ > $@; \
rm -f $@.$$$$