# rozszerzenia nazw plikw do usunicia w ramach zadania clean
CLEANEXTS = o a

# nazwa zadania docelowego i katalogu instalacyjnego
OUTPUTFILE = libjohnpaul.a
INSTALLDIR = ../binaries

# zadanie domylne
.PHONY: all
all: $(OUTPUTFILE)

# kompilacja bibioteki libjohnpaul.a z plikw john.o, paul.o i johnpaul.o
$(OUTPUTFILE): john.o paul.o johnpaul.o
	ar ru $@ $^
	ranlib $@

# Reguy opisujce kompilacj plikw john.o, paul.o i johnpaul.o z plikw .cpp
# nie s konieczne; mona si posuy reguami niejawnymi make

.PHONY: install
install:
	mkdir -p $(INSTALLDIR)
	cp -p $(OUTPUTFILE) $(INSTALLDIR)

.PHONY: clean
clean:
	for file in $(CLEANEXTS); do rm -f *.$$file; done

# oznaczenie zalenoci plikw .ccp od plikw .hpp
john.o: john.hpp
paul.o: paul.hpp
johnpaul.o: john.hpp paul.hpp johnpaul.hpp