#include <exception>
#include <iostream>     // cout
#include <xalanc/Include/PlatformDefinitions.hpp>
#include <xalanc/XalanTransformer/XalanTransformer.hpp>
#include <xalanc/XSLT/XSLTInputSource.hpp>
#include <xalanc/XSLT/XSLTResultTarget.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include "xerces_strings.hpp"  // listing 14.4

using namespace std;
using namespace xercesc;
using namespace xalanc;

// narzdzie RAII dbajce o inicjalizacj parsera 
// i zwolnienie zasobw po wyjciu z zasigu
struct XalanInitializer {
    XalanInitializer( ) 
    { 
        XMLPlatformUtils::Initialize( );
        XalanTransformer::initialize( );
    }
    ~XalanInitializer( ) 
    { 
        XalanTransformer::terminate( );
        XMLPlatformUtils::Terminate( );
    }
};

int main( )
{
    try {
        XalanInitializer  init;               // inicjalizacja infrastruktury Xalan
        XalanTransformer  xslt;               // transformator XSLT
        XSLTInputSource   xml("cyrk.xml");    // dokument XML z listingu 14.1.

        XSLTInputSource   xsl("cyrk.xsl");    // arkusz XSL z listingu 14.19

        XSLTResultTarget  html("cyrk.html");  // wynik transformacji

        // rozpoczcie przeksztacania
        if (xslt.transform(xml, xsl, html) != 0) {
            cout << "bd xml: " << xslt.getLastError( ) << "\n";
        }
    } catch (const XMLException& e) {
        cout << "bd xml: " << toNative(e.getMessage( )) << "\n";
        return EXIT_FAILURE;
    } catch (const exception& e) {
        cout << e.what( ) << "\n";
        return EXIT_FAILURE;
    }
}