/*
 * dyrektywy #include identyczne jak na listingu 14.14
 */

using namespace std;
using namespace xercesc;

/*
 * definicja klasy XercesInitializer jak na listingu 14.8
 * i klasy CircusErrorHandler jak na listingu 14.7
 */

int main( )
{
    try {
        // inicjalizacja infrastruktury Xerces i konstrukcja parsera DOM
        XercesInitializer        init;
        XercesDOMParser          parser;

        // wczenie walidacji
        parser.setValidationScheme(XercesDOMParser::Val_Always);
        parser.setDoSchema(true);
        parser.setDoNamespaces(true);
        parser.setExternalNoNamespaceSchemaLocation(
            fromNative("cyrk.xsd").c_str( )
        );

        // rejestracja obsugi bdw do odbioru 
        // powiadomie o naruszeniach schematu 
        CircusErrorHandler       handler;
        parser.setErrorHandler(&handler);

        // analiza i walidacja
        parser.parse("cyrk.xml");
    } catch (const SAXException& e) {
        cout << "bd xml: " << toNative(e.getMessage( )) << "\n";
        return EXIT_FAILURE;
    } catch (const XMLException& e) {
        cout << "bd xml: " << toNative(e.getMessage( )) << "\n";
        return EXIT_FAILURE;
    } catch (const exception& e) {
        cout << e.what( ) << "\n";
        return EXIT_FAILURE;
    }
}