#ifndef ANIMALS_HPP_INCLUDED
#define ANIMALS_HPP_INCLUDED

#include <ostream>
#include <string>
#include <stdexcept> // wyjtek runtime_error
#include <boost/date_time/gregorian/gregorian.hpp>
#include <boost/regex.hpp>

// reprezentuje dane opiekuna bd tresera
class Contact {
public:
    Contact( ) { }
    Contact(const std::string& name, const std::string& phone)
        : name_(name)
    { 
        setPhone(phone);
    }
    std::string name( ) const { return name_; }
    std::string phone( ) const { return phone_; }
    void setName(const std::string& name) { name_ = name; }
    void setPhone(const std::string& phone)
    { 
        using namespace std;
        using namespace boost;
        // Boost.Regex pozwoli sprawdzi zgodno zapisu
        // numeru telefonicznego z oczekiwanym formatem (ccc)ccc-cccc
        static regex pattern("\\([0-9]{3}\\)[0-9]{3}-[0-9]{4}");
        if (!regex_match(phone, pattern)) {
            throw runtime_error(string("niepoprawny zapis numeru telefonu:") + phone);
        }
        phone_ = phone;
    }
private:
    std::string name_;
    std::string phone_;
};

// porwnanie dwch obiektw typu Contacts; wykorzystywane w recepturze 14.9
// (dla porzdku naleaoby rwnie zdefiniowa operator operator!=)
bool operator==(const Contact& lhs, const Contact& rhs)
{
    return lhs.name( ) == rhs.name( ) && lhs.phone( ) == rhs.phone( );
}

// wypisanie obiektu Contact do strumienia wyjciowego
std::ostream& operator<<(std::ostream& out, const Contact& contact)
{
    out << contact.name( ) << " " << contact.phone( );
    return out;
}

// reprezentacja zwierzcia
class Animal {
public:
    // konstrukcja domylna obiektu klasy Animal;
    // najczciej wykorzystywany konstruktor
    Animal( ) { }

    // konstrukcja obiektu z zadanymi wasnociami; 
    // konstruktor wykorzystywany w recepturze 14.9
    Animal( const std::string& name, 
            const std::string& species, 
            const std::string& dob, 
            const Contact& vet, 
            const Contact& trainer )
        : name_(name),
          species_(species),
          vet_(vet),
          trainer_(trainer)
    { 
        setDateOfBirth(dob);
    }

    // akcesory
    std::string             name( ) const { return name_; }
    std::string             species( ) const { return species_; }
    boost::gregorian::date  dateOfBirth( ) const { return dob_; }
    Contact                 veterinarian( ) const { return vet_; }
    Contact                 trainer( ) const { return trainer_; }

    // akcesory
    void setName(const std::string& name) { name_ = name; }
    void setSpecies(const std::string& species) { species_ = species; }
    void setDateOfBirth(const std::string& dob) 
    { 
        dob_ = boost::gregorian::from_string(dob); 
    }
    void setVeterinarian(const Contact& vet) { vet_ = vet; }
    void setTrainer(const Contact& trainer) { trainer_ = trainer; }
private:
    std::string             name_;
    std::string             species_;
    boost::gregorian::date  dob_;
    Contact                 vet_;
    Contact                 trainer_;
};

// porwnanie dwch obiektw klasy Animal; wykorzystywane w recepturze 14.9
// (dla porzdku naleaoby rwnie zdefiniowa operator operator!=)
bool operator==(const Animal& lhs, const Animal& rhs)
{
    return lhs.name( ) == rhs.name( ) && 
           lhs.species( ) == rhs.species( ) && 
           lhs.dateOfBirth( ) == rhs.dateOfBirth( ) && 
           lhs.veterinarian( ) == rhs.veterinarian( ) && 
           lhs.trainer( ) == rhs.trainer( );
}

// wypisanie obiektu Animal do strumienia wyjciowego
std::ostream& operator<<(std::ostream& out, const Animal& animal)
{
    out << "obiekt Animal {\n"
        << "  name=" << animal.name( ) << ";\n"
        << "  species=" << animal.species( ) << ";\n"
        << "  date-of-birth=" << animal.dateOfBirth( ) << ";\n"
        << "  veterinarian=" << animal.veterinarian( ) << ";\n"
        << "  trainer=" << animal.trainer( ) << ";\n"
        << "}";
    return out;
}

#endif // #ifndef ANIMALS_HPP_INCLUDED