#include <iostream>
#include <locale>
#include <string>
#include <vector>
#include <algorithm>

using namespace std;

bool localeLessThan (const string& s1, const string& s2) {

   const collate<char>& col =
     use_facet<collate<char> >(locale( )); // zastosowanie globalnego
                                           // schematu lokalizacji

   const char* pb1 = s1.data( );
   const char* pb2 = s2.data( );

   return (col.compare(pb1, pb1 + s1.size( ),
                       pb2, pb2 + s2.size( )) < 0);
}

int main( ) {

   // utworzenie dwch cigw, z ktrych jeden zawiera
   // znaki alfabetu jzyka niemieckiego
   string s1 = "dit";
   string s2 = "dich";

   vector<string> v;
   v.push_back(s1);
   v.push_back(s2);

   // sortowanie bez wskazywania wasnego schematu lokalizacji,
   // a wic wedug schematu globalnego
   sort(v.begin( ), v.end( ));
   for (vector<string>::const_iterator p = v.begin( );
        p != v.end( ); ++p)
      cout << *p << endl;

   // sortowanie po ustawieniu globalnego schematu na jzyk niemiecki
   locale::global(locale("german"));
   sort(v.begin( ), v.end( ), localeLessThan);
   for (vector<string>::const_iterator p = v.begin( );
        p != v.end( ); ++p)
      cout << *p << endl;
}