#include <iostream>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/fstream.hpp>

using namespace boost::filesystem;

int main(int argc, char** argv) {

   if (argc < 2) {
      std::cerr << "Stosowanie: " << argv[0] << " [nazwa katalogu]\n";
      return(EXIT_FAILURE);
   }

   path fullPath =    // utworzenie penej, bezwzgldnej cieki dostpu
     system_complete(path(argv[1], native));

   if (!exists(fullPath)) {
      std::cerr << "Bd: katalog " << fullPath.string( )
                << " nie istnieje.\n";
      return(EXIT_FAILURE);
   }

   if (!is_directory(fullPath)) {
      std::cout << fullPath.string( ) << " nie jest katalogiem!\n";
      return(EXIT_SUCCESS);
   }

   directory_iterator end;
   for (directory_iterator it(fullPath);
        it != end; ++it) {               // przegldanie elementw
                                         // katalogu, niemal
      std::cout << it->leaf( );          // jak przegldanie elementw
      if (is_directory(*it))             // kontenera STL
         std::cout << " (dir)";
      std::cout << '\n';
   }

   return(EXIT_SUCCESS);
}