#include <iostream>
#include <istream>
#include <fstream>
#include <string>

using namespace std;

class Employee {
   friend ostream& operator<<              // koniecznie funkcje zaprzyjanione,
      (ostream& out, const Employee& emp); // aby miaa dostp do
   friend istream& operator>>              // skadowych niepublicznych
      (istream& in, Employee& emp);

public:
   Employee( ) {}
  ~Employee( ) {}

   void setFirstName(const string& name) {firstName_ = name;}
   void setLastName(const string& name) {lastName_ = name;}

private:
   string firstName_;
   string lastName_;
};

// zapisanie obiektu Employee do strumienia
ostream& operator<<(ostream& out, const Employee& emp) {

   out << emp.firstName_ << endl;
   out << emp.lastName_ << endl;

   return(out);
}

// wczytanie obiektu Employee ze strumienia
istream& operator>>(istream& in, Employee& emp) {

   in >> emp.firstName_;
   in >> emp.lastName_;

   return(in);
}

int main( ) {

   Employee emp;
   string first = "Jean-Luck";
   string last = "Pickard";

   emp.setFirstName(first);
   emp.setLastName(last);

   ofstream out("tmp\\emp.txt");

   if (!out) {
      cerr << "Nie mona otworzy pliku wyjciowego.\n";
      exit(EXIT_FAILURE);
   }

   out << emp;  // wypisanie Emp do pliku
   out.close( );

   ifstream in("tmp\\emp.txt");

   if (!in) {
      cerr << "Nie mona otworzy pliku wejciowego.\n";
      exit(EXIT_FAILURE);
   }

   Employee emp2;

   in >> emp2;  // wczytanie obiektu z pliku
   in.close( );

   cout << emp2;
}