#include <iostream>
#include <string>
#include <cctype>
#include <map>

using namespace std;

typedef map<string, string> StrStrMap;

// klasa przechowujca kontrolowany bufor testowy
class TextAutoField {

public:
   TextAutoField(StrStrMap* const p) : pDict_(p) {}
  ~TextAutoField( ) {}

   void append(char c);
   void getText(string& s) {s = buf_;}

private:
   TextAutoField( );
   string buf_;
   StrStrMap* const pDict_;
};

// dopisywanie do bufora z autokorekt
void TextAutoField::append(char c) {

   if ((isspace(c) || ispunct(c)) &&          // autokorekta podejmowana tylko
       buf_.length( ) > 0 &&                  // po dopisaniu znaku odstpu
       !isspace(buf_[buf_.length( ) - 1])) {  // albo znaku przestankowego

      string::size_type i = buf_.find_last_of(" \f\n\r\t\v");

      i = (i == string::npos) ? 0 : ++i;

      string tmp = buf_.substr(i, buf_.length( ) - i);
      StrStrMap::const_iterator p = pDict_->find(tmp);

      if (p != pDict_->end( )) {                   // jest wersja poprawna;
         buf_.erase(i, buf_.length( ) - i);        // wstawi poprawk
         buf_ += p->second;
      }
   }
   buf_ += c;
}

int main( ) {

   // wypenienie sownika
   StrStrMap dict;
   TextAutoField txt(&dict);

   dict["jets"] = "jest";
   dict["racja"] = "nieprawda";
   dict["bd"] = "poprawne";

   string tmp = "racja, to jets bd.";
   cout << "Tekst pierwotny: " << tmp << '\n';
   for (string::iterator p = tmp.begin( );
        p != tmp.end( ); ++p) {
      txt.append(*p);
   }

   txt.getText(tmp);

   cout << "Wersja poprawiona: " << tmp << '\n';
}
